/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import java.security.NoSuchAlgorithmException;
import net.shibboleth.utilities.java.support.codec.StringDigester;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.impl.EntityIDDigestGenerator;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EntityIDDigestGeneratorTest {
    private String controlValue;
    private String controlValueSHA1Hex;
    private CriteriaSet criteria;
    private EntityIDDigestGenerator generator;

    @BeforeMethod
    public void setUp() {
        this.controlValue = "urn:test:foobar";
        this.controlValueSHA1Hex = "d278c9975472a6b4827b1a8723192b4e99aa969c";
        this.criteria = new CriteriaSet();
    }

    @Test
    public void testBasic() throws NoSuchAlgorithmException {
        this.generator = new EntityIDDigestGenerator();
        Assert.assertNull((Object)this.generator.apply(null));
        this.criteria.clear();
        Assert.assertNull((Object)this.generator.apply(this.criteria));
        this.criteria.add((Object)new EntityIdCriterion(this.controlValue));
        Assert.assertEquals((String)this.controlValueSHA1Hex, (String)this.generator.apply(this.criteria));
        this.generator = new EntityIDDigestGenerator(null, "metadata-", ".xml", null);
        Assert.assertEquals((String)("metadata-" + this.controlValueSHA1Hex + ".xml"), (String)this.generator.apply(this.criteria));
        this.generator = new EntityIDDigestGenerator(null, "metadata", "xml", ".");
        Assert.assertEquals((String)("metadata." + this.controlValueSHA1Hex + ".xml"), (String)this.generator.apply(this.criteria));
        StringDigester digester = new StringDigester("SHA-1", StringDigester.OutputFormat.HEX_UPPER);
        this.generator = new EntityIDDigestGenerator(digester, null, null, null);
        Assert.assertEquals((String)this.controlValueSHA1Hex.toUpperCase(), (String)this.generator.apply(this.criteria));
        this.generator = new EntityIDDigestGenerator(digester, "metadata", "xml", ".");
        Assert.assertEquals((String)("metadata." + this.controlValueSHA1Hex.toUpperCase() + ".xml"), (String)this.generator.apply(this.criteria));
    }
}

