/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import com.google.common.collect.Sets;
import java.io.File;
import java.net.URL;
import java.util.HashSet;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.CriterionPredicateRegistry;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.criteria.entity.impl.EvaluableEntityRoleEntityDescriptorCriterion;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolverTest;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class PredicateFilteringTest
extends XMLObjectBaseTestCase {
    private FilesystemMetadataResolver metadataProvider;
    private File mdFile;
    private String entityID;
    private CriteriaSet criteriaSet;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.entityID = "urn:mace:incommon:washington.edu";
        URL mdURL = FilesystemMetadataResolverTest.class.getResource("/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
        this.mdFile = new File(mdURL.toURI());
        this.metadataProvider = new FilesystemMetadataResolver(this.mdFile);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        this.criteriaSet = new CriteriaSet();
    }

    @Test
    public void testResolveByEntityIDAndFilterByRole() throws ResolverException, ComponentInitializationException {
        CriterionPredicateRegistry registry = new CriterionPredicateRegistry();
        registry.register(EntityRoleCriterion.class, EvaluableEntityRoleEntityDescriptorCriterion.class);
        this.metadataProvider.setCriterionPredicateRegistry(registry);
        this.metadataProvider.initialize();
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new EntityIdCriterion(this.entityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        HashSet descriptors = Sets.newHashSet((Iterable)this.metadataProvider.resolve(this.criteriaSet));
        Assert.assertEquals((int)descriptors.size(), (int)1);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new EntityIdCriterion(this.entityID));
        this.criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        descriptors = Sets.newHashSet((Iterable)this.metadataProvider.resolve(this.criteriaSet));
        Assert.assertEquals((int)descriptors.size(), (int)0);
    }

    @Test
    public void testResolveByRoleViaPredicatesOnly() throws ResolverException, ComponentInitializationException {
        CriterionPredicateRegistry registry = new CriterionPredicateRegistry();
        registry.register(EntityRoleCriterion.class, EvaluableEntityRoleEntityDescriptorCriterion.class);
        this.metadataProvider.setCriterionPredicateRegistry(registry);
        this.metadataProvider.setResolveViaPredicatesOnly(true);
        this.metadataProvider.initialize();
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        HashSet descriptors = Sets.newHashSet((Iterable)this.metadataProvider.resolve(this.criteriaSet));
        Assert.assertEquals((int)descriptors.size(), (int)15);
        for (EntityDescriptor descriptor : descriptors) {
            Assert.assertTrue((descriptor.getRoleDescriptors(IDPSSODescriptor.DEFAULT_ELEMENT_NAME).size() > 0 ? 1 : 0) != 0);
        }
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        descriptors = Sets.newHashSet((Iterable)this.metadataProvider.resolve(this.criteriaSet));
        Assert.assertEquals((int)descriptors.size(), (int)16);
        for (EntityDescriptor descriptor : descriptors) {
            Assert.assertTrue((descriptor.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME).size() > 0 ? 1 : 0) != 0);
        }
    }

    @Test
    public void testResolveByRoleWithoutViaPredicatesOnly() throws ResolverException, ComponentInitializationException {
        CriterionPredicateRegistry registry = new CriterionPredicateRegistry();
        registry.register(EntityRoleCriterion.class, EvaluableEntityRoleEntityDescriptorCriterion.class);
        this.metadataProvider.setCriterionPredicateRegistry(registry);
        this.metadataProvider.setResolveViaPredicatesOnly(false);
        this.metadataProvider.initialize();
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        HashSet descriptors = Sets.newHashSet((Iterable)this.metadataProvider.resolve(this.criteriaSet));
        Assert.assertEquals((int)descriptors.size(), (int)0);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        descriptors = Sets.newHashSet((Iterable)this.metadataProvider.resolve(this.criteriaSet));
        Assert.assertEquals((int)descriptors.size(), (int)0);
    }
}

