/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.impl;

import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.saml.metadata.resolver.impl.RegexRequestURLBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class RegexRequestURLBuilderTest {
    private RegexRequestURLBuilder function;

    @Test
    public void testBasic() {
        this.function = new RegexRequestURLBuilder("^https?://([a-zA-Z0-9\\.]+).*$", "http://metadata.example.org/query?domain=$1");
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://example.org")})), (String)"http://metadata.example.org/query?domain=example.org");
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://example.org/")})), (String)"http://metadata.example.org/query?domain=example.org");
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://example.org/idp")})), (String)"http://metadata.example.org/query?domain=example.org");
        Assert.assertEquals((String)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("http://example.org:443/idp")})), (String)"http://metadata.example.org/query?domain=example.org");
        Assert.assertNull((Object)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("urn:test:foo")})));
        Assert.assertNull((Object)this.function.apply(new CriteriaSet(new Criterion[]{new EntityIdCriterion("ftp://example.org")})));
    }
}

