/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index.impl;

import java.util.Collections;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.opensaml.core.criterion.EntityIdCriterion;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.index.impl.ConstantEntityDescriptorFunction;
import org.opensaml.saml.metadata.resolver.index.impl.FunctionDrivenMetadataIndex;
import org.opensaml.saml.metadata.resolver.index.impl.MetadataIndexManager;
import org.opensaml.saml.metadata.resolver.index.impl.RoleMetadataIndex;
import org.opensaml.saml.metadata.resolver.index.impl.SimpleStringCriteriaFunction;
import org.opensaml.saml.metadata.resolver.index.impl.SimpleStringCriterion;
import org.opensaml.saml.metadata.resolver.index.impl.UppercaseEntityIdDescriptorFunction;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MetadataIndexManagerTest
extends XMLObjectBaseTestCase {
    private EntityDescriptor a;
    private EntityDescriptor b;
    private EntityDescriptor c;
    private SimpleStringCriterion critAEntity;
    private SimpleStringCriterion critBEntity;
    private SimpleStringCriterion critCEntity;
    private EntityRoleCriterion roleCritSP = new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
    private EntityRoleCriterion roleCritIDP = new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
    private CriteriaSet criteriaSet;
    private Optional<Set<EntityDescriptor>> result;
    private Function<EntityDescriptor, EntityDescriptor> extractionFunction;

    @BeforeMethod
    public void setUp() {
        this.a = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.a.setEntityID("urn:test:a");
        this.a.getRoleDescriptors().add((RoleDescriptor)XMLObjectSupport.buildXMLObject((QName)SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.critAEntity = new SimpleStringCriterion(this.a.getEntityID().toUpperCase());
        this.b = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.b.setEntityID("urn:test:b");
        this.b.getRoleDescriptors().add((RoleDescriptor)XMLObjectSupport.buildXMLObject((QName)IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.b.getRoleDescriptors().add((RoleDescriptor)XMLObjectSupport.buildXMLObject((QName)SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.critBEntity = new SimpleStringCriterion(this.b.getEntityID().toUpperCase());
        this.c = (EntityDescriptor)XMLObjectSupport.buildXMLObject((QName)EntityDescriptor.DEFAULT_ELEMENT_NAME);
        this.c.setEntityID("urn:test:c");
        this.c.getRoleDescriptors().add((RoleDescriptor)XMLObjectSupport.buildXMLObject((QName)IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        this.critCEntity = new SimpleStringCriterion(this.c.getEntityID().toUpperCase());
        this.criteriaSet = new CriteriaSet();
        this.extractionFunction = new MetadataIndexManager.IdentityExtractionFunction();
    }

    @Test
    public void testSingleIndexWithUniqueResults() {
        FunctionDrivenMetadataIndex functionIndex = new FunctionDrivenMetadataIndex((Function)new UppercaseEntityIdDescriptorFunction(), (Function)new SimpleStringCriteriaFunction());
        MetadataIndexManager manager = new MetadataIndexManager(Collections.singleton(functionIndex), this.extractionFunction);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critAEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertTrue((boolean)this.result.get().isEmpty());
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critBEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertTrue((boolean)this.result.get().isEmpty());
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critCEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertTrue((boolean)this.result.get().isEmpty());
        manager.indexEntityDescriptor(this.a);
        manager.indexEntityDescriptor(this.b);
        manager.indexEntityDescriptor(this.c);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critAEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)1);
        Assert.assertTrue((boolean)this.result.get().contains(this.a));
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critBEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)1);
        Assert.assertTrue((boolean)this.result.get().contains(this.b));
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critCEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)1);
        Assert.assertTrue((boolean)this.result.get().contains(this.c));
        manager.deindexEntityDescriptor(this.a);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critAEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertTrue((boolean)this.result.get().isEmpty());
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critBEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)1);
        Assert.assertTrue((boolean)this.result.get().contains(this.b));
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critCEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)1);
        Assert.assertTrue((boolean)this.result.get().contains(this.c));
        manager.deindexEntityDescriptor(this.b);
        manager.deindexEntityDescriptor(this.c);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critAEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertTrue((boolean)this.result.get().isEmpty());
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critBEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertTrue((boolean)this.result.get().isEmpty());
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critCEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertTrue((boolean)this.result.get().isEmpty());
    }

    @Test
    public void testSingleIndexWithNoResult() {
        FunctionDrivenMetadataIndex functionIndex = new FunctionDrivenMetadataIndex((Function)new UppercaseEntityIdDescriptorFunction(), (Function)new SimpleStringCriteriaFunction());
        MetadataIndexManager manager = new MetadataIndexManager(Collections.singleton(functionIndex), this.extractionFunction);
        manager.indexEntityDescriptor(this.a);
        manager.indexEntityDescriptor(this.b);
        manager.indexEntityDescriptor(this.c);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new SimpleStringCriterion("foobar"));
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertTrue((boolean)this.result.get().isEmpty());
    }

    @Test
    public void testSingleIndexWithMultipleResults() {
        RoleMetadataIndex roleIndex = new RoleMetadataIndex();
        MetadataIndexManager manager = new MetadataIndexManager(Collections.singleton(roleIndex), this.extractionFunction);
        manager.indexEntityDescriptor(this.a);
        manager.indexEntityDescriptor(this.b);
        manager.indexEntityDescriptor(this.c);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.roleCritSP);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)2);
        Assert.assertTrue((boolean)this.result.get().contains(this.a));
        Assert.assertTrue((boolean)this.result.get().contains(this.b));
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.roleCritIDP);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)2);
        Assert.assertTrue((boolean)this.result.get().contains(this.b));
        Assert.assertTrue((boolean)this.result.get().contains(this.c));
        manager.deindexEntityDescriptor(this.a);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.roleCritSP);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)1);
        Assert.assertTrue((boolean)this.result.get().contains(this.b));
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.roleCritIDP);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)2);
        Assert.assertTrue((boolean)this.result.get().contains(this.b));
        Assert.assertTrue((boolean)this.result.get().contains(this.c));
        manager.deindexEntityDescriptor(this.b);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.roleCritSP);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertTrue((boolean)this.result.get().isEmpty());
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.roleCritIDP);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)1);
        Assert.assertTrue((boolean)this.result.get().contains(this.c));
    }

    @Test
    public void testMultipleIndexesWithSingleResult() {
        RoleMetadataIndex roleIndex = new RoleMetadataIndex();
        FunctionDrivenMetadataIndex functionIndex = new FunctionDrivenMetadataIndex((Function)new UppercaseEntityIdDescriptorFunction(), (Function)new SimpleStringCriteriaFunction());
        MetadataIndexManager manager = new MetadataIndexManager(Set.of(roleIndex, functionIndex), this.extractionFunction);
        manager.indexEntityDescriptor(this.a);
        manager.indexEntityDescriptor(this.b);
        manager.indexEntityDescriptor(this.c);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.roleCritSP);
        this.criteriaSet.add((Object)this.critBEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)1);
        Assert.assertTrue((boolean)this.result.get().contains(this.b));
    }

    @Test
    public void testMultipleIndexesWithNoResult() {
        RoleMetadataIndex roleIndex = new RoleMetadataIndex();
        FunctionDrivenMetadataIndex functionIndex = new FunctionDrivenMetadataIndex((Function)new UppercaseEntityIdDescriptorFunction(), (Function)new SimpleStringCriteriaFunction());
        MetadataIndexManager manager = new MetadataIndexManager(Set.of(roleIndex, functionIndex), this.extractionFunction);
        manager.indexEntityDescriptor(this.a);
        manager.indexEntityDescriptor(this.b);
        manager.indexEntityDescriptor(this.c);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.roleCritSP);
        this.criteriaSet.add((Object)new SimpleStringCriterion("foobar"));
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertTrue((boolean)this.result.get().isEmpty());
    }

    @Test
    public void testMultipleIndexesWithMultipleResults() {
        RoleMetadataIndex roleIndex = new RoleMetadataIndex();
        FunctionDrivenMetadataIndex functionIndex = new FunctionDrivenMetadataIndex((Function)new ConstantEntityDescriptorFunction("All"), (Function)new SimpleStringCriteriaFunction());
        MetadataIndexManager manager = new MetadataIndexManager(Set.of(roleIndex, functionIndex), this.extractionFunction);
        manager.indexEntityDescriptor(this.a);
        manager.indexEntityDescriptor(this.b);
        manager.indexEntityDescriptor(this.c);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new SimpleStringCriterion("All"));
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)3);
        Assert.assertTrue((boolean)this.result.get().contains(this.a));
        Assert.assertTrue((boolean)this.result.get().contains(this.b));
        Assert.assertTrue((boolean)this.result.get().contains(this.c));
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.roleCritIDP);
        this.criteriaSet.add((Object)new SimpleStringCriterion("All"));
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertTrue((boolean)this.result.isPresent());
        Assert.assertFalse((boolean)this.result.get().isEmpty());
        Assert.assertEquals((int)this.result.get().size(), (int)2);
        Assert.assertTrue((boolean)this.result.get().contains(this.b));
        Assert.assertTrue((boolean)this.result.get().contains(this.c));
    }

    @Test
    public void testNoIndexes() {
        MetadataIndexManager manager = new MetadataIndexManager(Collections.emptySet(), this.extractionFunction);
        manager.indexEntityDescriptor(this.a);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)this.critAEntity);
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertFalse((boolean)this.result.isPresent());
    }

    @Test
    public void testNoApplicableCriteria() {
        FunctionDrivenMetadataIndex functionIndex = new FunctionDrivenMetadataIndex((Function)new UppercaseEntityIdDescriptorFunction(), (Function)new SimpleStringCriteriaFunction());
        MetadataIndexManager manager = new MetadataIndexManager(Collections.singleton(functionIndex), this.extractionFunction);
        manager.indexEntityDescriptor(this.a);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new EntityIdCriterion("urn:test:a"));
        this.result = manager.lookupIndexedItems(this.criteriaSet);
        Assert.assertFalse((boolean)this.result.isPresent());
    }
}

