/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.metadata.resolver.index.impl;

import java.io.File;
import java.net.URL;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.function.Function;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.ResolverException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.saml.common.binding.artifact.SAMLArtifact;
import org.opensaml.saml.criterion.ArtifactCriterion;
import org.opensaml.saml.criterion.EntityRoleCriterion;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolver;
import org.opensaml.saml.metadata.resolver.impl.FilesystemMetadataResolverTest;
import org.opensaml.saml.metadata.resolver.index.impl.FunctionDrivenMetadataIndex;
import org.opensaml.saml.metadata.resolver.index.impl.RoleMetadataIndex;
import org.opensaml.saml.metadata.resolver.index.impl.SAMLArtifactMetadataIndex;
import org.opensaml.saml.metadata.resolver.index.impl.SimpleStringCriteriaFunction;
import org.opensaml.saml.metadata.resolver.index.impl.SimpleStringCriterion;
import org.opensaml.saml.metadata.resolver.index.impl.UppercaseEntityIdDescriptorFunction;
import org.opensaml.saml.saml2.binding.artifact.SAML2ArtifactType0004;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class MetadataIndexingTest
extends XMLObjectBaseTestCase {
    private FilesystemMetadataResolver metadataProvider;
    private File mdFile;
    private String entityID;
    private byte[] artifactSourceID;
    private byte[] otherSourceID;
    private CriteriaSet criteriaSet;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.entityID = "urn:mace:incommon:washington.edu";
        MessageDigest sha1Digester = MessageDigest.getInstance("SHA-1");
        this.artifactSourceID = sha1Digester.digest(this.entityID.getBytes("UTF-8"));
        sha1Digester.reset();
        this.otherSourceID = sha1Digester.digest("foobar".getBytes("UTF-8"));
        HashSet<Object> indexes = new HashSet<Object>();
        indexes.add(new FunctionDrivenMetadataIndex((Function)new UppercaseEntityIdDescriptorFunction(), (Function)new SimpleStringCriteriaFunction()));
        indexes.add(new RoleMetadataIndex());
        indexes.add(new SAMLArtifactMetadataIndex());
        URL mdURL = FilesystemMetadataResolverTest.class.getResource("/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml");
        this.mdFile = new File(mdURL.toURI());
        this.metadataProvider = new FilesystemMetadataResolver(this.mdFile);
        this.metadataProvider.setParserPool(parserPool);
        this.metadataProvider.setId("test");
        this.metadataProvider.setIndexes(indexes);
        this.metadataProvider.initialize();
        this.criteriaSet = new CriteriaSet();
    }

    @Test
    public void testResolveByArtifactSourceID() throws ResolverException, NoSuchAlgorithmException {
        SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
        byte[] messageHandle = new byte[20];
        secureRandom.nextBytes(messageHandle);
        this.criteriaSet.clear();
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)descriptor);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new ArtifactCriterion((SAMLArtifact)new SAML2ArtifactType0004(new byte[]{0, 0}, this.otherSourceID, messageHandle)));
        descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)descriptor);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new ArtifactCriterion((SAMLArtifact)new SAML2ArtifactType0004(new byte[]{0, 0}, this.artifactSourceID, messageHandle)));
        descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testResolveSingleFromIndex() throws ResolverException {
        this.criteriaSet.clear();
        EntityDescriptor descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)descriptor);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new SimpleStringCriterion("foobar"));
        descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNull((Object)descriptor);
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new SimpleStringCriterion(this.entityID.toUpperCase()));
        descriptor = this.metadataProvider.resolveSingle(this.criteriaSet);
        Assert.assertNotNull((Object)descriptor, (String)"Retrieved entity descriptor was null");
        Assert.assertEquals((String)descriptor.getEntityID(), (String)this.entityID, (String)"Entity's ID does not match requested ID");
    }

    @Test
    public void testResolveRoles() throws ResolverException {
        HashSet<EntityDescriptor> descriptors = new HashSet<EntityDescriptor>();
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new EntityRoleCriterion(IDPSSODescriptor.DEFAULT_ELEMENT_NAME));
        descriptors.clear();
        for (EntityDescriptor descriptor : this.metadataProvider.resolve(this.criteriaSet)) {
            descriptors.add(descriptor);
        }
        Assert.assertEquals((int)descriptors.size(), (int)15);
        for (EntityDescriptor descriptor : descriptors) {
            Assert.assertTrue((descriptor.getRoleDescriptors(IDPSSODescriptor.DEFAULT_ELEMENT_NAME).size() > 0 ? 1 : 0) != 0);
        }
        this.criteriaSet.clear();
        this.criteriaSet.add((Object)new EntityRoleCriterion(SPSSODescriptor.DEFAULT_ELEMENT_NAME));
        descriptors.clear();
        for (EntityDescriptor descriptor : this.metadataProvider.resolve(this.criteriaSet)) {
            descriptors.add(descriptor);
        }
        Assert.assertEquals((int)descriptors.size(), (int)16);
        for (EntityDescriptor descriptor : descriptors) {
            Assert.assertTrue((descriptor.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME).size() > 0 ? 1 : 0) != 0);
        }
    }
}

