/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.binding.impl;

import java.io.IOException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.binding.artifact.impl.BasicSAMLArtifactMap;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml1.binding.impl.SAML1ArtifactRequestIssuerHandler;
import org.opensaml.saml.saml1.testing.SAML1ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SAML1ArtifactRequestIssuerHandlerTest
extends OpenSAMLInitBaseTestCase {
    private BasicSAMLArtifactMap artifactMap;
    private MessageContext mc;
    private SAML1ArtifactRequestIssuerHandler handler;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.artifactMap = new BasicSAMLArtifactMap();
        this.artifactMap.initialize();
        this.handler = new SAML1ArtifactRequestIssuerHandler();
        this.handler.setArtifactMap((SAMLArtifactMap)this.artifactMap);
        this.handler.initialize();
        this.mc = new MessageContext();
    }

    @Test
    public void testNoMessage() throws MessageHandlerException {
        this.handler.invoke(this.mc);
        Assert.assertFalse((boolean)this.mc.containsSubcontext(SAMLPeerEntityContext.class));
    }

    @Test
    public void testNoArtifacts() throws MessageHandlerException {
        this.mc.setMessage((Object)SAML1ActionTestingSupport.buildArtifactRequest((String[])null));
        this.handler.invoke(this.mc);
        Assert.assertFalse((boolean)this.mc.containsSubcontext(SAMLPeerEntityContext.class));
    }

    @Test
    public void testMissingArtifacts() throws MessageHandlerException {
        this.mc.setMessage((Object)SAML1ActionTestingSupport.buildArtifactRequest((String[])new String[]{"foo"}));
        this.handler.invoke(this.mc);
        Assert.assertFalse((boolean)this.mc.containsSubcontext(SAMLPeerEntityContext.class));
    }

    @Test
    public void testSuccess() throws MessageHandlerException, IOException {
        this.mc.setMessage((Object)SAML1ActionTestingSupport.buildArtifactRequest((String[])new String[]{"foo"}));
        this.artifactMap.put("foo", "https://sp.example.org", "https://idp.example.org", (SAMLObject)SAML1ActionTestingSupport.buildAssertion());
        this.handler.invoke(this.mc);
        SAMLPeerEntityContext peerCtx = (SAMLPeerEntityContext)this.mc.getSubcontext(SAMLPeerEntityContext.class);
        Assert.assertNotNull((Object)peerCtx);
        Assert.assertEquals((String)peerCtx.getEntityId(), (String)"https://sp.example.org");
    }
}

