/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml1.core.Action;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ActionTest
extends XMLObjectProviderBaseTestCase {
    private final String expectedContents;
    private final String expectedNamespace;
    private final QName qname;

    public ActionTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAction.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleActionAttributes.xml";
        this.expectedNamespace = "namespace";
        this.expectedContents = "Action Contents";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Action", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        Action action = (Action)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)action.getNamespace(), (String)"namespace attribute present");
        Assert.assertNull((Object)action.getValue(), (String)"Contents present");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Action action = (Action)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)action.getNamespace(), (String)this.expectedNamespace, (String)"namespace attribute ");
        Assert.assertEquals((String)action.getValue(), (String)this.expectedContents, (String)"Contents ");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Action action = (Action)this.buildXMLObject(this.qname);
        action.setNamespace(this.expectedNamespace);
        action.setValue(this.expectedContents);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)action);
    }
}

