/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.time.Instant;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml1.core.Advice;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AttributeStatement;
import org.opensaml.saml.saml1.core.AuthenticationStatement;
import org.opensaml.saml.saml1.core.AuthorizationDecisionStatement;
import org.opensaml.saml.saml1.core.Conditions;
import org.opensaml.saml.saml1.core.Statement;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class AssertionTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final int expectedMinorVersion;
    private final String expectedIssuer;
    private final Instant expectedIssueInstant = Instant.parse("1970-01-02T01:01:02.100Z");
    private final String expectedID;

    public AssertionTest() {
        this.expectedID = "ident";
        this.expectedMinorVersion = 1;
        this.expectedIssuer = "issuer";
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleAssertion.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleAssertionAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/AssertionWithChildren.xml";
        this.qname = Assertion.DEFAULT_ELEMENT_NAME;
    }

    @Test
    public void testSingleElementUnmarshall() {
        Assertion assertion = (Assertion)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)assertion.getIssuer(), (String)"Issuer attribute");
        Assert.assertNull((Object)assertion.getIssueInstant(), (String)"IssueInstant attribute");
        Assert.assertNull((Object)assertion.getID(), (String)"ID attribute");
        Assert.assertNull((Object)assertion.getConditions(), (String)"Conditions element");
        Assert.assertNull((Object)assertion.getAdvice(), (String)"Advice element");
        Assert.assertNull((Object)assertion.getSignature(), (String)"Signature element");
        Assert.assertEquals((int)assertion.getStatements().size(), (int)0, (String)"Statement element count");
        Assert.assertEquals((int)assertion.getAttributeStatements().size(), (int)0, (String)"AttributeStatements element count");
        Assert.assertEquals((int)assertion.getSubjectStatements().size(), (int)0, (String)"SubjectStatements element count");
        Assert.assertEquals((int)assertion.getAuthenticationStatements().size(), (int)0, (String)"AuthenticationStatements element count");
        Assert.assertEquals((int)assertion.getAuthorizationDecisionStatements().size(), (int)0, (String)"AuthorizationDecisionStatements element count");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Assertion assertion = (Assertion)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)assertion.getIssuer(), (String)this.expectedIssuer, (String)"Issuer attribute");
        Assert.assertEquals((Object)assertion.getIssueInstant(), (Object)this.expectedIssueInstant, (String)"IssueInstant attribute");
        Assert.assertEquals((String)assertion.getID(), (String)this.expectedID, (String)"ID attribute");
        Assert.assertEquals((int)assertion.getMinorVersion(), (int)this.expectedMinorVersion, (String)"Issuer expectedMinorVersion");
        Assert.assertNull((Object)assertion.getConditions(), (String)"Conditions element");
        Assert.assertNull((Object)assertion.getAdvice(), (String)"Advice element");
        Assert.assertNull((Object)assertion.getSignature(), (String)"Signature element");
        Assert.assertEquals((int)assertion.getStatements().size(), (int)0, (String)"Statement element count");
        Assert.assertEquals((int)assertion.getAttributeStatements().size(), (int)0, (String)"AttributeStatements element count");
        Assert.assertEquals((int)assertion.getSubjectStatements().size(), (int)0, (String)"SubjectStatements element count");
        Assert.assertEquals((int)assertion.getAuthenticationStatements().size(), (int)0, (String)"AuthenticationStatements element count");
        Assert.assertEquals((int)assertion.getAuthorizationDecisionStatements().size(), (int)0, (String)"AuthorizationDecisionStatements element count");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Assertion assertion = (Assertion)this.unmarshallElement(this.childElementsFile);
        Assert.assertNull((Object)assertion.getIssuer(), (String)"Issuer attribute");
        Assert.assertNull((Object)assertion.getID(), (String)"ID attribute");
        Assert.assertNull((Object)assertion.getIssueInstant(), (String)"IssueInstant attribute");
        Assert.assertNotNull((Object)assertion.getConditions(), (String)"Conditions element null");
        Assert.assertNotNull((Object)assertion.getAdvice(), (String)"Advice element null");
        Assert.assertNull((Object)assertion.getSignature(), (String)"Signature element");
        Assert.assertNotNull((Object)assertion.getAuthenticationStatements(), (String)"No Authentication Statements");
        Assert.assertEquals((int)assertion.getAuthenticationStatements().size(), (int)2, (String)"AuthenticationStatements element count");
        Assert.assertNotNull((Object)assertion.getAttributeStatements(), (String)"No Attribute Statements");
        Assert.assertEquals((int)assertion.getAttributeStatements().size(), (int)3, (String)"AttributeStatements element count");
        Assert.assertNotNull((Object)assertion.getAuthorizationDecisionStatements(), (String)"No AuthorizationDecisionStatements ");
        Assert.assertEquals((int)assertion.getAuthorizationDecisionStatements().size(), (int)3, (String)"AuthorizationDecisionStatements element count");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(this.qname);
        ((Assertion)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Assertion assertion = (Assertion)this.buildXMLObject(this.qname);
        assertion.setIssueInstant(this.expectedIssueInstant);
        assertion.setID(this.expectedID);
        assertion.setIssuer(this.expectedIssuer);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)assertion);
    }

    @Test
    public void testChildElementsMarshall() {
        Assertion assertion = (Assertion)this.buildXMLObject(this.qname);
        assertion.setConditions((Conditions)this.buildXMLObject(Conditions.DEFAULT_ELEMENT_NAME));
        assertion.setAdvice((Advice)this.buildXMLObject(Advice.DEFAULT_ELEMENT_NAME));
        QName authenticationQname = AuthenticationStatement.DEFAULT_ELEMENT_NAME;
        QName authorizationQname = AuthorizationDecisionStatement.DEFAULT_ELEMENT_NAME;
        QName attributeQname = AttributeStatement.DEFAULT_ELEMENT_NAME;
        assertion.getStatements().add((Statement)this.buildXMLObject(authenticationQname));
        assertion.getStatements().add((Statement)this.buildXMLObject(authorizationQname));
        assertion.getStatements().add((Statement)this.buildXMLObject(attributeQname));
        assertion.getStatements().add((Statement)this.buildXMLObject(authenticationQname));
        assertion.getStatements().add((Statement)this.buildXMLObject(authorizationQname));
        assertion.getStatements().add((Statement)this.buildXMLObject(attributeQname));
        assertion.getStatements().add((Statement)this.buildXMLObject(authorizationQname));
        assertion.getStatements().add((Statement)this.buildXMLObject(attributeQname));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)assertion);
    }

    @Test
    public void testSignatureUnmarshall() {
        Assertion assertion = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml1/impl/AssertionWithSignature.xml");
        Assert.assertNotNull((Object)assertion, (String)"Assertion was null");
        Assert.assertNotNull((Object)assertion.getSignature(), (String)"Signature was null");
        Assert.assertNotNull((Object)assertion.getSignature().getKeyInfo(), (String)"KeyInfo was null");
    }

    @Test
    public void testDOMIDResolutionUnmarshall() {
        Assertion assertion = (Assertion)this.unmarshallElement("/org/opensaml/saml/saml1/impl/AssertionWithSignature.xml");
        Assert.assertNotNull((Object)assertion, (String)"Assertion was null");
        Assert.assertNotNull((Object)assertion.getSignature(), (String)"Signature was null");
        Document document = assertion.getSignature().getDOM().getOwnerDocument();
        Element idElem = assertion.getDOM();
        Assert.assertNotNull((Object)document.getElementById(this.expectedID), (String)"DOM ID resolution returned null");
        Assert.assertTrue((boolean)idElem.isSameNode(document.getElementById(this.expectedID)), (String)"DOM elements were not equal");
    }

    @Test
    public void testDOMIDResolutionMarshall() throws MarshallingException {
        Assertion assertion = (Assertion)this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME);
        assertion.setID(this.expectedID);
        assertion.getAttributeStatements().add((AttributeStatement)this.buildXMLObject(AttributeStatement.DEFAULT_ELEMENT_NAME));
        marshallerFactory.getMarshaller((XMLObject)assertion).marshall((XMLObject)assertion);
        Document document = ((Statement)assertion.getStatements().get(0)).getDOM().getOwnerDocument();
        Element idElem = assertion.getDOM();
        Assert.assertNotNull((Object)document.getElementById(this.expectedID), (String)"DOM ID resolution returned null");
        Assert.assertTrue((boolean)idElem.isSameNode(document.getElementById(this.expectedID)), (String)"DOM elements were not equal");
    }
}

