/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml1.core.Assertion;
import org.opensaml.saml.saml1.core.AssertionIDReference;
import org.opensaml.saml.saml1.core.Evidence;
import org.testng.Assert;
import org.testng.annotations.Test;

public class EvidenceTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;

    public EvidenceTest() {
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleEvidence.xml";
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/EvidenceWithChildren.xml";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Evidence", "saml1");
    }

    @Test
    public void testSingleElementUnmarshall() {
        Evidence evidence = (Evidence)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((int)evidence.getEvidence().size(), (int)0, (String)"AssertionIDReference or Assertion element was present");
    }

    @Test
    public void testChildElementsUnmarshall() {
        Evidence evidence = (Evidence)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)evidence.getEvidence().size(), (int)4, (String)"Assertion and AssertionIDReference element count");
        Assert.assertEquals((int)evidence.getAssertionIDReferences().size(), (int)2, (String)"AssertionIDReference element count");
        Assert.assertEquals((int)evidence.getAssertions().size(), (int)2, (String)"Assertion element count");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testChildElementsMarshall() {
        Evidence evidence = (Evidence)this.buildXMLObject(this.qname);
        QName refQname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "AssertionIDReference", "saml1");
        QName assertionQname = new QName("urn:oasis:names:tc:SAML:1.0:assertion", "Assertion", "saml1");
        evidence.getAssertionIDReferences().add((AssertionIDReference)this.buildXMLObject(refQname));
        evidence.getAssertions().add((Assertion)this.buildXMLObject(assertionQname));
        evidence.getAssertions().add((Assertion)this.buildXMLObject(assertionQname));
        evidence.getAssertionIDReferences().add((AssertionIDReference)this.buildXMLObject(refQname));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)evidence);
    }
}

