/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import java.time.Instant;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml1.core.AssertionArtifact;
import org.opensaml.saml.saml1.core.AssertionIDReference;
import org.opensaml.saml.saml1.core.AttributeQuery;
import org.opensaml.saml.saml1.core.Query;
import org.opensaml.saml.saml1.core.Request;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RequestTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;
    private final String expectedID;
    private final Instant expectedIssueInstant;
    private final int expectedMinorVersion;

    public RequestTest() {
        this.expectedID = "ident";
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleRequest.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml1/impl/singleRequestAttributes.xml";
        this.expectedIssueInstant = Instant.parse("1970-01-01T00:00:00.100Z");
        this.expectedMinorVersion = 1;
        this.qname = Request.DEFAULT_ELEMENT_NAME;
    }

    @Test
    public void testSingleElementUnmarshall() {
        Request request = (Request)this.unmarshallElement(this.singleElementFile);
        String id = request.getID();
        Assert.assertNull((Object)id, (String)("ID attribute has value " + id + "expected no value"));
        Instant date = request.getIssueInstant();
        Assert.assertNull((Object)date, (String)("IssueInstant attribute has a value of " + date + ", expected no value"));
        Assert.assertNull((Object)request.getQuery(), (String)"Query has value");
        Assert.assertEquals((int)request.getAssertionArtifacts().size(), (int)0, (String)"AssertionArtifact present");
        Assert.assertEquals((int)request.getAssertionIDReferences().size(), (int)0, (String)"AssertionIDReferences present");
        Assert.assertNull((Object)request.getIssueInstant(), (String)"IssueInstance has value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Request request = (Request)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)request.getID(), (String)this.expectedID, (String)"ID");
        Assert.assertEquals((int)request.getVersion().getMinorVersion(), (int)this.expectedMinorVersion, (String)"MinorVersion");
        Assert.assertEquals((Object)request.getIssueInstant(), (Object)this.expectedIssueInstant, (String)"IssueInstant");
    }

    @Test
    public void testSingleElementChildrenUnmarshall() {
        Request request = (Request)this.unmarshallElement("/org/opensaml/saml/saml1/impl/RequestWithAssertionArtifact.xml");
        Assert.assertNull((Object)request.getQuery(), (String)"Query is not null");
        Assert.assertEquals((int)request.getAssertionIDReferences().size(), (int)0, (String)"AssertionId count");
        Assert.assertEquals((int)request.getAssertionArtifacts().size(), (int)2, (String)"AssertionArtifact count");
        request = (Request)this.unmarshallElement("/org/opensaml/saml/saml1/impl/RequestWithQuery.xml");
        Assert.assertNotNull((Object)request.getQuery(), (String)"Query is null");
        Assert.assertEquals((int)request.getAssertionIDReferences().size(), (int)0, (String)"AssertionId count");
        Assert.assertEquals((int)request.getAssertionArtifacts().size(), (int)0, (String)"AssertionArtifact count");
        request = (Request)this.unmarshallElement("/org/opensaml/saml/saml1/impl/RequestWithAssertionIDReference.xml");
        Assert.assertNull((Object)request.getQuery(), (String)"Query is not null");
        Assert.assertNotNull((Object)request.getAssertionIDReferences(), (String)"AssertionId");
        Assert.assertEquals((int)request.getAssertionIDReferences().size(), (int)3, (String)"AssertionId count");
        Assert.assertEquals((int)request.getAssertionArtifacts().size(), (int)0, (String)"AssertionArtifact count");
    }

    @Test
    public void testSingleElementMarshall() {
        this.assertXMLEquals(this.expectedDOM, this.buildXMLObject(this.qname));
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(Request.DEFAULT_ELEMENT_NAME);
        ((Request)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        Request request = (Request)this.buildXMLObject(this.qname);
        request.setID(this.expectedID);
        request.setIssueInstant(this.expectedIssueInstant);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)request);
    }

    @Test
    public void testSingleElementChildrenMarshall() {
        try {
            Document dom = parserPool.parse(((Object)((Object)this)).getClass().getResourceAsStream("/org/opensaml/saml/saml1/impl/RequestWithAssertionArtifact.xml"));
            Request request = (Request)this.buildXMLObject(this.qname);
            QName oqname = AssertionArtifact.DEFAULT_ELEMENT_NAME;
            request.getAssertionArtifacts().add((AssertionArtifact)this.buildXMLObject(oqname));
            request.getAssertionArtifacts().add((AssertionArtifact)this.buildXMLObject(oqname));
            this.assertXMLEquals(dom, (XMLObject)request);
            dom = parserPool.parse(((Object)((Object)this)).getClass().getResourceAsStream("/org/opensaml/saml/saml1/impl/RequestWithAssertionIDReference.xml"));
            request = (Request)this.buildXMLObject(this.qname);
            oqname = AssertionIDReference.DEFAULT_ELEMENT_NAME;
            request.getAssertionIDReferences().add((AssertionIDReference)this.buildXMLObject(oqname));
            request.getAssertionIDReferences().add((AssertionIDReference)this.buildXMLObject(oqname));
            request.getAssertionIDReferences().add((AssertionIDReference)this.buildXMLObject(oqname));
            this.assertXMLEquals(dom, (XMLObject)request);
            dom = parserPool.parse(((Object)((Object)this)).getClass().getResourceAsStream("/org/opensaml/saml/saml1/impl/RequestWithQuery.xml"));
            request = (Request)this.buildXMLObject(this.qname);
            oqname = AttributeQuery.DEFAULT_ELEMENT_NAME;
            request.setQuery((Query)((AttributeQuery)this.buildXMLObject(oqname)));
            this.assertXMLEquals(dom, (XMLObject)request);
        }
        catch (XMLParserException e) {
            Assert.fail((String)e.toString());
        }
    }

    @Test
    public void testSignatureUnmarshall() {
        Request request = (Request)this.unmarshallElement("/org/opensaml/saml/saml1/impl/RequestWithSignature.xml");
        Assert.assertNotNull((Object)request, (String)"Request was null");
        Assert.assertNotNull((Object)request.getSignature(), (String)"Signature was null");
        Assert.assertNotNull((Object)request.getSignature().getKeyInfo(), (String)"KeyInfo was null");
    }

    @Test
    public void testDOMIDResolutionUnmarshall() {
        Request request = (Request)this.unmarshallElement("/org/opensaml/saml/saml1/impl/RequestWithSignature.xml");
        Assert.assertNotNull((Object)request, (String)"Request was null");
        Assert.assertNotNull((Object)request.getSignature(), (String)"Signature was null");
        Document document = request.getSignature().getDOM().getOwnerDocument();
        Element idElem = request.getDOM();
        Assert.assertNotNull((Object)document.getElementById(this.expectedID), (String)"DOM ID resolution returned null");
        Assert.assertTrue((boolean)idElem.isSameNode(document.getElementById(this.expectedID)), (String)"DOM elements were not equal");
    }

    @Test
    public void testDOMIDResolutionMarshall() throws MarshallingException {
        Request request = (Request)this.buildXMLObject(Request.DEFAULT_ELEMENT_NAME);
        request.setID(this.expectedID);
        request.setQuery((Query)((AttributeQuery)this.buildXMLObject(AttributeQuery.DEFAULT_ELEMENT_NAME)));
        marshallerFactory.getMarshaller((XMLObject)request).marshall((XMLObject)request);
        Document document = request.getQuery().getDOM().getOwnerDocument();
        Element idElem = request.getDOM();
        Assert.assertNotNull((Object)document.getElementById(this.expectedID), (String)"DOM ID resolution returned null");
        Assert.assertTrue((boolean)idElem.isSameNode(document.getElementById(this.expectedID)), (String)"DOM elements were not equal");
    }
}

