/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml1.core.StatusCode;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StatusCodeTest
extends XMLObjectProviderBaseTestCase {
    private final QName qname;

    public StatusCodeTest() {
        this.childElementsFile = "/org/opensaml/saml/saml1/impl/FullStatusCode.xml";
        this.singleElementFile = "/org/opensaml/saml/saml1/impl/singleStatusCode.xml";
        this.qname = new QName("urn:oasis:names:tc:SAML:1.0:protocol", "StatusCode", "saml1p");
    }

    @Test
    public void testSingleElementUnmarshall() {
        StatusCode code = (StatusCode)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((Object)code.getValue(), (Object)StatusCode.SUCCESS, (String)"Single Element Value wrong");
    }

    @Test
    public void testChildElementsUnmarshall() {
        StatusCode code = (StatusCode)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)code.getStatusCode(), (String)"Child StatusCode");
    }

    @Test
    public void testSingleElementMarshall() {
        StatusCode code = (StatusCode)this.buildXMLObject(this.qname);
        code.setValue(StatusCode.SUCCESS);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)code);
    }

    @Test
    public void testChildElementsMarshall() {
        StatusCode code = (StatusCode)this.buildXMLObject(this.qname);
        code.setValue(StatusCode.REQUESTER);
        code.setStatusCode((StatusCode)this.buildXMLObject(this.qname));
        code.getStatusCode().setValue(StatusCode.VERSION_MISMATCH);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)code);
    }
}

