/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml1.profile.impl;

import java.io.IOException;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.FunctionSupport;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.binding.artifact.SAMLArtifactMap;
import org.opensaml.saml.common.binding.artifact.impl.BasicSAMLArtifactMap;
import org.opensaml.saml.common.messaging.context.SAMLPeerEntityContext;
import org.opensaml.saml.saml1.core.Response;
import org.opensaml.saml.saml1.profile.impl.ResolveArtifacts;
import org.opensaml.saml.saml1.testing.SAML1ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ResolveArtifactsTest
extends OpenSAMLInitBaseTestCase {
    private BasicSAMLArtifactMap artifactMap;
    private ProfileRequestContext prc;
    private ResolveArtifacts action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().setOutboundMessage((Object)SAML1ActionTestingSupport.buildResponse()).buildProfileRequestContext();
        ((SAMLPeerEntityContext)this.prc.getInboundMessageContext().getSubcontext(SAMLPeerEntityContext.class, true)).setEntityId("SP");
        this.artifactMap = new BasicSAMLArtifactMap();
        this.artifactMap.initialize();
        this.action = new ResolveArtifacts();
        this.action.setArtifactMap((SAMLArtifactMap)this.artifactMap);
        this.action.setIssuerLookupStrategy(FunctionSupport.constant((Object)"IdP"));
        this.action.initialize();
    }

    @Test
    public void testNoRequest() {
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoArtifacts() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildArtifactRequest((String[])null));
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoResponse() {
        this.prc.getInboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildArtifactRequest((String[])new String[]{"foo"}));
        this.prc.getOutboundMessageContext().setMessage(null);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testMissingArtifacts() throws IOException {
        this.artifactMap.put("bar", "SP", "IdP", (SAMLObject)SAML1ActionTestingSupport.buildAssertion());
        this.prc.getInboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildArtifactRequest((String[])new String[]{"foo", "bar"}));
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToResolveArtifact");
        Assert.assertTrue((boolean)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().isEmpty());
        Assert.assertNull((Object)this.artifactMap.get("bar"));
    }

    @Test
    public void testWrongMessageType() throws IOException {
        this.artifactMap.put("foo", "SP", "IdP", (SAMLObject)SAML1ActionTestingSupport.buildResponse());
        this.prc.getInboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildArtifactRequest((String[])new String[]{"foo"}));
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToResolveArtifact");
        Assert.assertTrue((boolean)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().isEmpty());
        Assert.assertNull((Object)this.artifactMap.get("foo"));
    }

    @Test
    public void testWrongSP() throws IOException {
        this.artifactMap.put("foo", "SP2", "IdP", (SAMLObject)SAML1ActionTestingSupport.buildAssertion());
        this.prc.getInboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildArtifactRequest((String[])new String[]{"foo"}));
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToResolveArtifact");
        Assert.assertTrue((boolean)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().isEmpty());
        Assert.assertNull((Object)this.artifactMap.get("foo"));
    }

    @Test
    public void testWrongIdP() throws IOException {
        this.artifactMap.put("foo", "SP", "IdP2", (SAMLObject)SAML1ActionTestingSupport.buildAssertion());
        this.prc.getInboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildArtifactRequest((String[])new String[]{"foo"}));
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"UnableToResolveArtifact");
        Assert.assertTrue((boolean)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().isEmpty());
        Assert.assertNull((Object)this.artifactMap.get("foo"));
    }

    @Test
    public void testOne() throws IOException {
        this.artifactMap.put("foo", "SP", "IdP", (SAMLObject)SAML1ActionTestingSupport.buildAssertion());
        this.prc.getInboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildArtifactRequest((String[])new String[]{"foo"}));
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertEquals((int)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().size(), (int)1);
        Assert.assertNull((Object)this.artifactMap.get("foo"));
    }

    @Test
    public void testMultiple() throws IOException {
        this.artifactMap.put("foo", "SP", "IdP", (SAMLObject)SAML1ActionTestingSupport.buildAssertion());
        this.artifactMap.put("bar", "SP", "IdP", (SAMLObject)SAML1ActionTestingSupport.buildAssertion());
        this.prc.getInboundMessageContext().setMessage((Object)SAML1ActionTestingSupport.buildArtifactRequest((String[])new String[]{"foo", "bar"}));
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertEquals((int)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().size(), (int)2);
        Assert.assertNull((Object)this.artifactMap.get("foo"));
        Assert.assertNull((Object)this.artifactMap.get("bar"));
    }
}

