/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import java.util.Collections;
import java.util.Map;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.impl.AudienceRestrictionConditionValidator;
import org.opensaml.saml.saml2.assertion.tests.BaseAssertionValidationTest;
import org.opensaml.saml.saml2.core.Audience;
import org.opensaml.saml.saml2.core.AudienceRestriction;
import org.opensaml.saml.saml2.core.Condition;
import org.opensaml.saml.saml2.core.OneTimeUse;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AudienceRestrictionConditionValidatorTest
extends BaseAssertionValidationTest {
    private String expectedAudienceURI = "https://sp.example.com";
    private AudienceRestrictionConditionValidator validator;
    private Condition condition;
    private Audience audience;

    @BeforeMethod(dependsOnMethods={"setUpBasicAssertion"})
    public void setUp() {
        this.validator = new AudienceRestrictionConditionValidator();
        this.audience = (Audience)this.buildXMLObject(Audience.DEFAULT_ELEMENT_NAME);
        this.audience.setURI(this.expectedAudienceURI);
        this.condition = (Condition)this.buildXMLObject(AudienceRestriction.DEFAULT_ELEMENT_NAME);
        ((AudienceRestriction)this.condition).getAudiences().add(this.audience);
        this.getAssertion().getConditions().getConditions().add(this.condition);
    }

    @Test
    public void testValid() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.Conditions.ValidAudiences", Collections.singleton(this.expectedAudienceURI));
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.condition, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testInvalidParamType() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.Conditions.ValidAudiences", this.expectedAudienceURI);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.condition, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testMissingParam() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.condition, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testConditionWithNoAudiences() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.Conditions.ValidAudiences", Collections.singleton(this.expectedAudienceURI));
        ((AudienceRestriction)this.condition).getAudiences().clear();
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.condition, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testUnexpectedCondition() throws AssertionValidationException {
        this.condition = (Condition)this.buildXMLObject(OneTimeUse.DEFAULT_ELEMENT_NAME);
        this.getAssertion().getConditions().getConditions().add(this.condition);
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.Conditions.ValidAudiences", Collections.singleton(this.expectedAudienceURI));
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate(this.condition, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }
}

