/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.Map;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.impl.AuthnStatementValidator;
import org.opensaml.saml.saml2.assertion.tests.BaseAssertionValidationTest;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Statement;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuthnStatementValidatorTest
extends BaseAssertionValidationTest {
    private AuthnStatementValidator validator;
    private AuthnStatement authnStatement;

    @BeforeMethod(dependsOnMethods={"setUpBasicAssertion"})
    public void setUp() {
        this.validator = new AuthnStatementValidator();
        this.authnStatement = this.buildBasicAuthnStatement();
        this.getAssertion().getAuthnStatements().add(this.authnStatement);
    }

    @Test
    public void testValid() throws AssertionValidationException {
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate((Statement)this.authnStatement, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    void testMaxTimeSinceAuthnExceeded() throws AssertionValidationException {
        this.authnStatement.setAuthnInstant(Instant.now().minus(Duration.ofHours(1L)));
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate((Statement)this.authnStatement, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    void testNoAuthnInstant() throws AssertionValidationException {
        this.authnStatement.setAuthnInstant(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate((Statement)this.authnStatement, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    void testNoMaxTimeSinceAuthnParam() throws AssertionValidationException {
        this.authnStatement.setAuthnInstant(Instant.now().minus(Duration.ofHours(1L)));
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.remove("saml2.Statement.Authn.MaxTimeSinceAuthn");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate((Statement)this.authnStatement, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testInvalidAddress() throws AssertionValidationException {
        this.authnStatement.getSubjectLocality().setAddress("1.2.3.4");
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate((Statement)this.authnStatement, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testInvalidAddressWithAddressCheckDisabled() throws AssertionValidationException {
        this.authnStatement.getSubjectLocality().setAddress("1.2.3.4");
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.Statement.Authn.SubjectLocality.CheckAddress", Boolean.FALSE);
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate((Statement)this.authnStatement, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testInvalidAddressParamType() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.put("saml2.Statement.Authn.SubjectLocality.ValidAddresses", "10.1.2.3");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate((Statement)this.authnStatement, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testMissingAddressParam() throws AssertionValidationException {
        Map<String, Object> staticParams = this.buildBasicStaticParameters();
        staticParams.remove("saml2.Statement.Authn.SubjectLocality.ValidAddresses");
        ValidationContext validationContext = new ValidationContext(staticParams);
        Assert.assertEquals((Object)this.validator.validate((Statement)this.authnStatement, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testNoAddress() throws AssertionValidationException {
        this.authnStatement.getSubjectLocality().setAddress(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate((Statement)this.authnStatement, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testNoSubjectLocality() throws AssertionValidationException {
        this.authnStatement.setSubjectLocality(null);
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate((Statement)this.authnStatement, this.getAssertion(), validationContext), (Object)ValidationResult.VALID);
    }

    @Test
    public void testAuthnContextEval() throws AssertionValidationException {
        this.validator = new AuthnStatementValidator(){

            protected ValidationResult validateAuthnContext(AuthnStatement statement, Assertion assertion, ValidationContext context) throws AssertionValidationException {
                return "urn:oasis:names:tc:SAML:2.0:ac:classes:Smartcard".equals(statement.getAuthnContext().getAuthnContextClassRef().getURI()) ? ValidationResult.VALID : ValidationResult.INVALID;
            }
        };
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate((Statement)this.authnStatement, this.getAssertion(), validationContext), (Object)ValidationResult.INVALID);
    }

    @Test
    public void testValidationThrows() throws AssertionValidationException {
        this.validator = new AuthnStatementValidator(){

            protected ValidationResult validateAuthnInstant(AuthnStatement statement, Assertion assertion, ValidationContext context) throws AssertionValidationException {
                throw new RuntimeException();
            }
        };
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate((Statement)this.authnStatement, this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }

    @Test
    public void testWrongStatementType() throws AssertionValidationException {
        ValidationContext validationContext = new ValidationContext(this.buildBasicStaticParameters());
        Assert.assertEquals((Object)this.validator.validate((Statement)this.buildXMLObject(AttributeStatement.DEFAULT_ELEMENT_NAME), this.getAssertion(), validationContext), (Object)ValidationResult.INDETERMINATE);
    }
}

