/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.tests;

import java.io.File;
import java.net.InetAddress;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import java.security.KeyException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObjectBuilder;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnStatement;
import org.opensaml.saml.saml2.core.Conditions;
import org.opensaml.saml.saml2.core.SubjectConfirmation;
import org.opensaml.saml.saml2.core.SubjectConfirmationData;
import org.opensaml.saml.saml2.core.SubjectLocality;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.opensaml.security.SecurityException;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialSupport;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.security.x509.X509Support;
import org.opensaml.xmlsec.SignatureSigningParameters;
import org.opensaml.xmlsec.signature.SignableXMLObject;
import org.opensaml.xmlsec.signature.support.SignatureException;
import org.opensaml.xmlsec.signature.support.SignatureSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;

public class BaseAssertionValidationTest
extends XMLObjectBaseTestCase {
    public static final Duration CLOCK_SKEW = Duration.ofMinutes(5L);
    public static final String PRINCIPAL_NAME = "gollum";
    public static final String ISSUER = "https://idp.example.org";
    public static final String SUBJECT_CONFIRMATION_RECIPIENT = "https://sp.example.com";
    public static final String SUBJECT_CONFIRMATION_ADDRESS = "10.1.2.3";
    public static final String SUBJECT_CONFIRMATION_IN_RESPONSE_TO = "id-123";
    public static final String AUTHN_STATEMENT_ADDRESS = "10.1.2.3";
    private Assertion assertion;

    protected Assertion getAssertion() {
        return this.assertion;
    }

    @BeforeMethod
    protected void setUpBasicAssertion() {
        this.assertion = SAML2ActionTestingSupport.buildAssertion();
        this.assertion.setIssueInstant(Instant.now());
        this.assertion.setIssuer(SAML2ActionTestingSupport.buildIssuer((String)ISSUER));
        this.assertion.setSubject(SAML2ActionTestingSupport.buildSubject((String)PRINCIPAL_NAME));
        this.assertion.setConditions(this.buildBasicConditions());
        SubjectConfirmation subjectConfirmation = (SubjectConfirmation)this.buildXMLObject(SubjectConfirmation.DEFAULT_ELEMENT_NAME);
        subjectConfirmation.setMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        subjectConfirmation.setSubjectConfirmationData(this.buildBasicSubjectConfirmationData());
        this.assertion.getSubject().getSubjectConfirmations().add(subjectConfirmation);
    }

    protected Conditions buildBasicConditions() {
        Conditions conditions = (Conditions)this.buildXMLObject(Conditions.DEFAULT_ELEMENT_NAME);
        Instant now = Instant.now();
        conditions.setNotBefore(now.minus(5L, ChronoUnit.MINUTES));
        conditions.setNotOnOrAfter(now.plus(5L, ChronoUnit.MINUTES));
        return conditions;
    }

    protected SubjectConfirmationData buildBasicSubjectConfirmationData() {
        return this.buildBasicSubjectConfirmationData(null);
    }

    protected SubjectConfirmationData buildBasicSubjectConfirmationData(QName type) {
        SubjectConfirmationData scd = null;
        if (type != null) {
            XMLObjectBuilder builder = this.getBuilder(type);
            scd = (SubjectConfirmationData)builder.buildObject(SubjectConfirmationData.DEFAULT_ELEMENT_NAME, type);
        } else {
            scd = (SubjectConfirmationData)this.buildXMLObject(SubjectConfirmationData.DEFAULT_ELEMENT_NAME);
        }
        scd.setInResponseTo(SUBJECT_CONFIRMATION_IN_RESPONSE_TO);
        scd.setRecipient(SUBJECT_CONFIRMATION_RECIPIENT);
        scd.setAddress("10.1.2.3");
        Instant now = Instant.now();
        scd.setNotBefore(now.minus(5L, ChronoUnit.MINUTES));
        scd.setNotOnOrAfter(now.plus(5L, ChronoUnit.MINUTES));
        return scd;
    }

    protected AuthnStatement buildBasicAuthnStatement() {
        AuthnStatement authnStatement = (AuthnStatement)this.buildXMLObject(AuthnStatement.DEFAULT_ELEMENT_NAME);
        Instant now = Instant.now();
        authnStatement.setAuthnInstant(now.minusSeconds(5L));
        SubjectLocality sl = (SubjectLocality)this.buildXMLObject(SubjectLocality.DEFAULT_ELEMENT_NAME);
        sl.setAddress("10.1.2.3");
        authnStatement.setSubjectLocality(sl);
        AuthnContextClassRef accr = (AuthnContextClassRef)this.buildXMLObject(AuthnContextClassRef.DEFAULT_ELEMENT_NAME);
        accr.setURI("urn:oasis:names:tc:SAML:2.0:ac:classes:Password");
        AuthnContext ac = (AuthnContext)this.buildXMLObject(AuthnContext.DEFAULT_ELEMENT_NAME);
        ac.setAuthnContextClassRef(accr);
        authnStatement.setAuthnContext(ac);
        return authnStatement;
    }

    protected Map<String, Object> buildBasicStaticParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("saml2.ClockSkew", CLOCK_SKEW);
        params.put("saml2.ValidIssuers", Collections.singleton(ISSUER));
        params.put("saml2.SubjectConfirmation.ValidInResponseTo", SUBJECT_CONFIRMATION_IN_RESPONSE_TO);
        params.put("saml2.SubjectConfirmation.ValidRecipients", Collections.singleton(SUBJECT_CONFIRMATION_RECIPIENT));
        try {
            params.put("saml2.SubjectConfirmation.ValidAddresses", Collections.singleton(InetAddress.getByName("10.1.2.3")));
        }
        catch (UnknownHostException e) {
            Assert.fail((String)"Invalid address: 10.1.2.3");
        }
        params.put("saml2.Statement.Authn.MaxTimeSinceAuthn", Duration.ofMinutes(5L));
        try {
            params.put("saml2.Statement.Authn.SubjectLocality.ValidAddresses", Collections.singleton(InetAddress.getByName("10.1.2.3")));
        }
        catch (UnknownHostException e) {
            Assert.fail((String)"Invalid address: 10.1.2.3");
        }
        return params;
    }

    protected X509Certificate getCertificate(String name) throws CertificateException, URISyntaxException {
        File certFile = new File(((Object)((Object)this)).getClass().getResource("/org/opensaml/saml/saml2/assertion/" + name).toURI());
        return X509Support.decodeCertificate((File)certFile);
    }

    protected PrivateKey getPrivateKey(String name) throws KeyException, URISyntaxException {
        File keyFile = new File(((Object)((Object)this)).getClass().getResource("/org/opensaml/saml/saml2/assertion/" + name).toURI());
        return KeySupport.decodePrivateKey((File)keyFile, null);
    }

    protected Credential getSigningCredential(PublicKey publicKey, PrivateKey privateKey) {
        BasicCredential cred = CredentialSupport.getSimpleCredential((PublicKey)publicKey, (PrivateKey)privateKey);
        cred.setUsageType(UsageType.SIGNING);
        cred.setEntityId(ISSUER);
        return cred;
    }

    protected void signAssertion(Assertion a, Credential credential) throws SecurityException, MarshallingException, SignatureException {
        SignatureSigningParameters parameters = new SignatureSigningParameters();
        parameters.setSigningCredential(credential);
        parameters.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        parameters.setSignatureReferenceDigestMethod("http://www.w3.org/2001/04/xmlenc#sha256");
        parameters.setSignatureCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        SignatureSupport.signObject((SignableXMLObject)a, (SignatureSigningParameters)parameters);
    }
}

