/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.assertion.tests;

import java.util.Collections;
import java.util.Map;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.shibboleth.utilities.java.support.logic.Constraint;
import org.opensaml.saml.common.assertion.AssertionValidationException;
import org.opensaml.saml.common.assertion.ValidationContext;
import org.opensaml.saml.common.assertion.ValidationResult;
import org.opensaml.saml.saml2.assertion.SAML20AssertionValidator;
import org.opensaml.saml.saml2.core.Assertion;

public class MockAssertionValidator
extends SAML20AssertionValidator {
    private Map<Assertion, Object> resultsMap;

    public MockAssertionValidator(Map<Assertion, Object> results) {
        super(Collections.emptyList(), Collections.emptyList(), Collections.emptyList(), null, null);
        this.resultsMap = (Map)Constraint.isNotNull(results, (String)"Results map was null");
    }

    public ValidationResult validate(Assertion assertion, ValidationContext context) throws AssertionValidationException {
        Object result = this.resultsMap.get(assertion);
        if (Throwable.class.isInstance(result)) {
            Throwable throwable = (Throwable)Throwable.class.cast(result);
            if (AssertionValidationException.class.isInstance(throwable)) {
                throw (AssertionValidationException)AssertionValidationException.class.cast(throwable);
            }
            if (RuntimeException.class.isInstance(throwable)) {
                throw (RuntimeException)RuntimeException.class.cast(throwable);
            }
            if (Error.class.isInstance(throwable)) {
                throw (Error)Error.class.cast(throwable);
            }
            if (Exception.class.isInstance(throwable)) {
                throw new AssertionValidationException((Exception)Exception.class.cast(throwable));
            }
            throw new RuntimeException(throwable);
        }
        if (ValidationResult.class.isInstance(result)) {
            ValidationResult vr = (ValidationResult)ValidationResult.class.cast(result);
            if (!ValidationResult.VALID.equals((Object)vr)) {
                context.setValidationFailureMessage("Mock validation was not valid");
            }
            return vr;
        }
        if (Pair.class.isInstance(result)) {
            Pair pair = (Pair)Pair.class.cast(result);
            if (!ValidationResult.VALID.equals(pair.getFirst())) {
                context.setValidationFailureMessage((String)pair.getSecond());
            }
            return (ValidationResult)pair.getFirst();
        }
        throw new IllegalArgumentException(String.format("Invalid result type supplied in mock results map for Assertion '%s': %s", assertion, result));
    }
}

