/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.binding.decoding.impl;

import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.codec.DecodingException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.saml.common.binding.SAMLBindingSupport;
import org.opensaml.saml.saml2.binding.decoding.impl.HTTPPostDecoder;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.opensaml.saml.saml2.core.Response;
import org.springframework.mock.web.MockHttpServletRequest;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class HTTPPostDecoderTest
extends XMLObjectBaseTestCase {
    private String expectedRelayValue = "relay";
    private HTTPPostDecoder decoder;
    private MockHttpServletRequest httpRequest;
    private static final String INVALID_BASE64_TRAILING = "AB==";

    @BeforeMethod
    protected void setUp() throws Exception {
        this.httpRequest = new MockHttpServletRequest();
        this.httpRequest.setMethod("POST");
        this.httpRequest.setParameter("RelayState", this.expectedRelayValue);
        this.decoder = new HTTPPostDecoder();
        this.decoder.setParserPool(parserPool);
        this.decoder.setHttpServletRequest((HttpServletRequest)this.httpRequest);
        this.decoder.initialize();
    }

    @Test
    public void testRequestDecoding() throws MessageDecodingException {
        this.httpRequest.setParameter("SAMLRequest", "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHNhbWxwOkF1dGhuUmVxdWVzdCBJRD0iZm9vIiBJc3N1ZUluc3RhbnQ9IjE5NzAtMDEtMDFUMDA6MDA6MDAuMDAwWiIgVmVyc2lvbj0iMi4wIiB4bWxuczpzYW1scD0idXJuOm9hc2lzOm5hbWVzOnRjOlNBTUw6Mi4wOnByb3RvY29sIi8+");
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        Assert.assertTrue((boolean)(messageContext.getMessage() instanceof RequestAbstractType));
        Assert.assertEquals((String)SAMLBindingSupport.getRelayState((MessageContext)messageContext), (String)this.expectedRelayValue);
    }

    @Test
    public void testInvalidRequestDecoding() {
        block2: {
            this.httpRequest.setParameter("SAMLRequest", INVALID_BASE64_TRAILING);
            try {
                this.decoder.decode();
            }
            catch (MessageDecodingException e) {
                if (e.getCause() instanceof DecodingException) break block2;
                Assert.fail((String)"Expected DecodingException type");
            }
        }
    }

    @Test
    public void testResponseDecoding() throws MessageDecodingException {
        this.httpRequest.setParameter("SAMLResponse", "PD94bWwgdmVyc2lvbj0iMS4wIiBlbmNvZGluZz0iVVRGLTgiPz4KPHNhbWxwOlJlc3BvbnNlIElEPSJmb28iIElzc3VlSW5zdGFudD0iMTk3MC0wMS0wMVQwMDowMDowMC4wMDBaIiBWZXJzaW9uPSIyLjAiIHhtbG5zOnNhbWxwPSJ1cm46b2FzaXM6bmFtZXM6dGM6U0FNTDoyLjA6cHJvdG9jb2wiPjxzYW1scDpTdGF0dXM+PHNhbWxwOlN0YXR1c0NvZGUgVmFsdWU9InVybjpvYXNpczpuYW1lczp0YzpTQU1MOjIuMDpzdGF0dXM6U3VjY2VzcyIvPjwvc2FtbHA6U3RhdHVzPjwvc2FtbHA6UmVzcG9uc2U+");
        this.decoder.decode();
        MessageContext messageContext = this.decoder.getMessageContext();
        Assert.assertTrue((boolean)(messageContext.getMessage() instanceof Response));
        Assert.assertEquals((String)SAMLBindingSupport.getRelayState((MessageContext)messageContext), (String)this.expectedRelayValue);
    }
}

