/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.ArtifactResponse;
import org.opensaml.saml.saml2.core.impl.StatusResponseTestBase;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ArtifactResponseTest
extends StatusResponseTestBase {
    public ArtifactResponseTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/ArtifactResponse.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/ArtifactResponseOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/ArtifactResponseChildElements.xml";
    }

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "ArtifactResponse", "saml2p");
        ArtifactResponse ar = (ArtifactResponse)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)ar);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)ar);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(ArtifactResponse.DEFAULT_ELEMENT_NAME);
        ((ArtifactResponse)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "ArtifactResponse", "saml2p");
        ArtifactResponse ar = (ArtifactResponse)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)ar);
        super.populateOptionalAttributes((SAMLObject)ar);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)ar);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "ArtifactResponse", "saml2p");
        ArtifactResponse ar = (ArtifactResponse)this.buildXMLObject(qname);
        super.populateChildElements((SAMLObject)ar);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)ar);
    }

    @Override
    @Test
    public void testSingleElementUnmarshall() {
        ArtifactResponse ar = (ArtifactResponse)this.unmarshallElement(this.singleElementFile);
        super.helperTestSingleElementUnmarshall((SAMLObject)ar);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        ArtifactResponse ar = (ArtifactResponse)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        super.helperTestSingleElementOptionalAttributesUnmarshall((SAMLObject)ar);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ArtifactResponse ar = (ArtifactResponse)this.unmarshallElement(this.childElementsFile);
        super.helperTestChildElementsUnmarshall((SAMLObject)ar);
    }
}

