/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.core.AttributeStatement;
import org.opensaml.saml.saml2.core.EncryptedAttribute;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AttributeStatementTest
extends XMLObjectProviderBaseTestCase {
    private int expectedAttributeCount = 3;
    private int expectedEncryptedAttributeCount = 3;

    public AttributeStatementTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/AttributeStatement.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/AttributeStatementChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeStatement attributeStatement = (AttributeStatement)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)attributeStatement);
    }

    @Test
    public void testChildElementsUnmarshall() {
        AttributeStatement attributeStatement = (AttributeStatement)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)attributeStatement.getAttributes().size(), (int)this.expectedAttributeCount, (String)"Attribute Count");
        Assert.assertEquals((int)attributeStatement.getEncryptedAttributes().size(), (int)this.expectedEncryptedAttributeCount, (String)"EncryptedAttribute Count");
    }

    @Test
    public void testSingleElementMarshall() {
        AttributeStatement attributeStatement = (AttributeStatement)this.buildXMLObject(AttributeStatement.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)attributeStatement);
    }

    @Test
    public void testChildElementsMarshall() {
        AttributeStatement attributeStatement = (AttributeStatement)this.buildXMLObject(AttributeStatement.DEFAULT_ELEMENT_NAME);
        attributeStatement.getAttributes().add((Attribute)this.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME));
        attributeStatement.getEncryptedAttributes().add((EncryptedAttribute)this.buildXMLObject(EncryptedAttribute.DEFAULT_ELEMENT_NAME));
        attributeStatement.getAttributes().add((Attribute)this.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME));
        attributeStatement.getEncryptedAttributes().add((EncryptedAttribute)this.buildXMLObject(EncryptedAttribute.DEFAULT_ELEMENT_NAME));
        attributeStatement.getEncryptedAttributes().add((EncryptedAttribute)this.buildXMLObject(EncryptedAttribute.DEFAULT_ELEMENT_NAME));
        attributeStatement.getAttributes().add((Attribute)this.buildXMLObject(Attribute.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)attributeStatement);
    }
}

