/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.core.AuthenticatingAuthority;
import org.opensaml.saml.saml2.core.AuthnContext;
import org.opensaml.saml.saml2.core.AuthnContextClassRef;
import org.opensaml.saml.saml2.core.AuthnContextDecl;
import org.opensaml.saml.saml2.core.AuthnContextDeclRef;
import org.testng.Assert;
import org.testng.annotations.Test;

public class AuthnContextTest
extends XMLObjectProviderBaseTestCase {
    protected int expectedAuthenticatingAuthorityCount = 2;

    public AuthnContextTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/AuthnContext.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/AuthnContextChildElements.xml";
    }

    @Test
    public void testSingleElementUnmarshall() {
        AuthnContext authnContext = (AuthnContext)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)authnContext);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContext", "saml2");
        AuthnContext authnContext = (AuthnContext)this.buildXMLObject(qname);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)authnContext);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
    }

    @Test
    public void testChildElementsUnmarshall() {
        AuthnContext authnContext = (AuthnContext)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)authnContext.getAuthnContextClassRef(), (String)"AuthnContextClassRef element not present");
        Assert.assertNotNull((Object)authnContext.getAuthContextDecl(), (String)"AuthnContextDecl element not present");
        Assert.assertNotNull((Object)authnContext.getAuthnContextDeclRef(), (String)"AuthnContextDeclRef element not present");
        Assert.assertEquals((int)authnContext.getAuthenticatingAuthorities().size(), (int)this.expectedAuthenticatingAuthorityCount, (String)"AuthenticatingAuthorityCount Count");
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContext", "saml2");
        AuthnContext authnContext = (AuthnContext)this.buildXMLObject(qname);
        QName authnContextClassRefQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContextClassRef", "saml2");
        authnContext.setAuthnContextClassRef((AuthnContextClassRef)this.buildXMLObject(authnContextClassRefQName));
        QName authnContextDeclQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContextDecl", "saml2");
        authnContext.setAuthnContextDecl((AuthnContextDecl)this.buildXMLObject(authnContextDeclQName));
        QName authnContextDeclRefQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthnContextDeclRef", "saml2");
        authnContext.setAuthnContextDeclRef((AuthnContextDeclRef)this.buildXMLObject(authnContextDeclRefQName));
        QName authenticatingAuthorityQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "AuthenticatingAuthority", "saml2");
        for (int i = 0; i < this.expectedAuthenticatingAuthorityCount; ++i) {
            authnContext.getAuthenticatingAuthorities().add((AuthenticatingAuthority)this.buildXMLObject(authenticatingAuthorityQName));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)authnContext);
    }
}

