/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.AuthnQuery;
import org.opensaml.saml.saml2.core.RequestedAuthnContext;
import org.opensaml.saml.saml2.core.impl.SubjectQueryTestBase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AuthnQueryTest
extends SubjectQueryTestBase {
    private String expectedSessionIndex;

    public AuthnQueryTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/AuthnQuery.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/AuthnQueryOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/AuthnQueryChildElements.xml";
    }

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
        this.expectedSessionIndex = "session12345";
    }

    @Override
    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnQuery", "saml2p");
        AuthnQuery query = (AuthnQuery)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)query);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)query);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(AuthnQuery.DEFAULT_ELEMENT_NAME);
        ((AuthnQuery)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnQuery", "saml2p");
        AuthnQuery query = (AuthnQuery)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)query);
        super.populateOptionalAttributes((SAMLObject)query);
        query.setSessionIndex(this.expectedSessionIndex);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)query);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "AuthnQuery", "saml2p");
        AuthnQuery query = (AuthnQuery)this.buildXMLObject(qname);
        super.populateChildElements((SAMLObject)query);
        QName requestedAuthnContextQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "RequestedAuthnContext", "saml2p");
        query.setRequestedAuthnContext((RequestedAuthnContext)this.buildXMLObject(requestedAuthnContextQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)query);
    }

    @Override
    @Test
    public void testSingleElementUnmarshall() {
        AuthnQuery query = (AuthnQuery)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)query, (String)"AuthnQuery");
        Assert.assertNull((Object)query.getSessionIndex(), (String)"SessionIndex");
        super.helperTestSingleElementUnmarshall((SAMLObject)query);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AuthnQuery query = (AuthnQuery)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        super.helperTestSingleElementOptionalAttributesUnmarshall((SAMLObject)query);
        Assert.assertEquals((String)query.getSessionIndex(), (String)this.expectedSessionIndex, (String)"Unmarshalled SessionIndex was not the expected value");
    }

    @Test
    public void testChildElementsUnmarshall() {
        AuthnQuery query = (AuthnQuery)this.unmarshallElement(this.childElementsFile);
        super.helperTestChildElementsUnmarshall((SAMLObject)query);
        Assert.assertNotNull((Object)query.getRequestedAuthnContext(), (String)"RequestedAuthnContext");
    }
}

