/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.NameID;
import org.opensaml.saml.saml2.core.NameIDMappingResponse;
import org.opensaml.saml.saml2.core.impl.StatusResponseTestBase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class NameIDMappingResponseTest
extends StatusResponseTestBase {
    public NameIDMappingResponseTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/NameIDMappingResponse.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/NameIDMappingResponseOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/NameIDMappingResponseChildElements.xml";
    }

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
    }

    @Override
    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "NameIDMappingResponse", "saml2p");
        NameIDMappingResponse resp = (NameIDMappingResponse)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)resp);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)resp);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(NameIDMappingResponse.DEFAULT_ELEMENT_NAME);
        ((NameIDMappingResponse)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "NameIDMappingResponse", "saml2p");
        NameIDMappingResponse resp = (NameIDMappingResponse)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)resp);
        super.populateOptionalAttributes((SAMLObject)resp);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)resp);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "NameIDMappingResponse", "saml2p");
        NameIDMappingResponse req = (NameIDMappingResponse)this.buildXMLObject(qname);
        super.populateChildElements((SAMLObject)req);
        QName nameIDQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "NameID", "saml2");
        req.setNameID((NameID)this.buildXMLObject(nameIDQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)req);
    }

    @Override
    @Test
    public void testSingleElementUnmarshall() {
        NameIDMappingResponse resp = (NameIDMappingResponse)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)resp, (String)"NameIDMappingResponse was null");
        super.helperTestSingleElementUnmarshall((SAMLObject)resp);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        NameIDMappingResponse resp = (NameIDMappingResponse)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)resp, (String)"NameIDMappingResponse was null");
        super.helperTestSingleElementOptionalAttributesUnmarshall((SAMLObject)resp);
    }

    @Test
    public void testChildElementsUnmarshall() {
        NameIDMappingResponse resp = (NameIDMappingResponse)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)resp.getNameID(), (String)"Identifier was null");
        super.helperTestChildElementsUnmarshall((SAMLObject)resp);
    }
}

