/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.saml.saml2.core.NameIDPolicy;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class NameIDPolicyTest
extends XMLObjectProviderBaseTestCase {
    private String expectedFormat;
    private String expectedSPNameQualifer;
    private XSBooleanValue expectedAllowCreate;

    public NameIDPolicyTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/NameIDPolicy.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/NameIDPolicyOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedFormat = "urn:string:format";
        this.expectedSPNameQualifer = "urn:string:spname";
        this.expectedAllowCreate = new XSBooleanValue(Boolean.TRUE, false);
    }

    @Test
    public void testSingleElementMarshall() {
        NameIDPolicy policy = (NameIDPolicy)this.buildXMLObject(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)policy);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        NameIDPolicy policy = (NameIDPolicy)this.buildXMLObject(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        policy.setFormat(this.expectedFormat);
        policy.setSPNameQualifier(this.expectedSPNameQualifer);
        policy.setAllowCreate(this.expectedAllowCreate);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)policy);
    }

    @Test
    public void testSingleElementUnmarshall() {
        NameIDPolicy policy = (NameIDPolicy)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)policy);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        NameIDPolicy policy = (NameIDPolicy)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)policy.getFormat(), (String)this.expectedFormat, (String)"Unmarshalled name Format URI attribute value was not the expected value");
        Assert.assertEquals((String)policy.getSPNameQualifier(), (String)this.expectedSPNameQualifer, (String)"Unmarshalled SPNameQualifier URI attribute value was not the expected value");
        Assert.assertEquals((Object)policy.getAllowCreateXSBoolean(), (Object)this.expectedAllowCreate, (String)"Unmarshalled AllowCreate attribute value was not the expected value");
    }

    @Test
    public void testXSBooleanAttributes() {
        NameIDPolicy policy = (NameIDPolicy)this.buildXMLObject(NameIDPolicy.DEFAULT_ELEMENT_NAME);
        policy.setAllowCreate(Boolean.TRUE);
        Assert.assertEquals((Object)policy.getAllowCreate(), (Object)Boolean.TRUE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)policy.getAllowCreateXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)policy.getAllowCreateXSBoolean(), (Object)new XSBooleanValue(Boolean.TRUE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)policy.getAllowCreateXSBoolean().toString(), (String)"true", (String)"XSBooleanValue string was unexpected value");
        policy.setAllowCreate(Boolean.FALSE);
        Assert.assertEquals((Object)policy.getAllowCreate(), (Object)Boolean.FALSE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)policy.getAllowCreateXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)policy.getAllowCreateXSBoolean(), (Object)new XSBooleanValue(Boolean.FALSE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)policy.getAllowCreateXSBoolean().toString(), (String)"false", (String)"XSBooleanValue string was unexpected value");
        policy.setAllowCreate((Boolean)null);
        Assert.assertEquals((Object)policy.getAllowCreate(), (Object)Boolean.FALSE, (String)"Unexpected default value for boolean attribute found");
        Assert.assertNull((Object)policy.getAllowCreateXSBoolean(), (String)"XSBooleanValue was not null");
    }
}

