/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import java.time.Instant;
import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.RequestAbstractType;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class RequestTestBase
extends XMLObjectProviderBaseTestCase {
    protected String expectedID;
    protected SAMLVersion expectedSAMLVersion;
    protected Instant expectedIssueInstant;
    protected String expectedDestination;
    protected String expectedConsent;
    protected Issuer expectedIssuer;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedID = "abc123";
        this.expectedSAMLVersion = SAMLVersion.VERSION_20;
        this.expectedIssueInstant = Instant.parse("2006-02-21T16:40:00.000Z");
        this.expectedDestination = "http://idp.example.org/endpoint";
        this.expectedConsent = "urn:string:consent";
        QName issuerQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "saml2");
        this.expectedIssuer = (Issuer)this.buildXMLObject(issuerQName);
    }

    @Test
    public abstract void testSingleElementUnmarshall();

    @Test
    public abstract void testSingleElementMarshall();

    protected void populateRequiredAttributes(SAMLObject samlObject) {
        RequestAbstractType req = (RequestAbstractType)samlObject;
        req.setID(this.expectedID);
        req.setIssueInstant(this.expectedIssueInstant);
    }

    protected void populateOptionalAttributes(SAMLObject samlObject) {
        RequestAbstractType req = (RequestAbstractType)samlObject;
        req.setConsent(this.expectedConsent);
        req.setDestination(this.expectedDestination);
    }

    protected void populateChildElements(SAMLObject samlObject) {
        RequestAbstractType req = (RequestAbstractType)samlObject;
        req.setIssuer(this.expectedIssuer);
    }

    protected void helperTestSingleElementUnmarshall(SAMLObject samlObject) {
        RequestAbstractType req = (RequestAbstractType)samlObject;
        Assert.assertEquals((String)req.getID(), (String)this.expectedID, (String)"Unmarshalled ID attribute was not the expected value");
        Assert.assertEquals((String)req.getVersion().toString(), (String)this.expectedSAMLVersion.toString(), (String)"Unmarshalled Version attribute was not the expected value");
        Assert.assertEquals((int)this.expectedIssueInstant.compareTo(req.getIssueInstant()), (int)0, (String)"Unmarshalled IssueInstant attribute was not the expected value");
        Assert.assertNull((Object)req.getConsent(), (String)"Consent was not null");
        Assert.assertNull((Object)req.getDestination(), (String)"Destination was not null");
    }

    protected void helperTestSingleElementOptionalAttributesUnmarshall(SAMLObject samlObject) {
        RequestAbstractType req = (RequestAbstractType)samlObject;
        Assert.assertEquals((String)req.getID(), (String)this.expectedID, (String)"Unmarshalled ID attribute was not the expected value");
        Assert.assertEquals((String)req.getVersion().toString(), (String)this.expectedSAMLVersion.toString(), (String)"Unmarshalled Version attribute was not the expected value");
        Assert.assertEquals((int)this.expectedIssueInstant.compareTo(req.getIssueInstant()), (int)0, (String)"Unmarshalled IssueInstant attribute was not the expected value");
        Assert.assertEquals((String)req.getConsent(), (String)this.expectedConsent, (String)"Unmarshalled Consent attribute was not the expected value");
        Assert.assertEquals((String)req.getDestination(), (String)this.expectedDestination, (String)"Unmarshalled Destination attribute was not the expected value");
    }

    protected void helperTestChildElementsUnmarshall(SAMLObject samlObject) {
        RequestAbstractType req = (RequestAbstractType)samlObject;
        Assert.assertNotNull((Object)req.getIssuer(), (String)"Issuer was null");
    }
}

