/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.impl.StatusResponseTestBase;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ResponseTest
extends StatusResponseTestBase {
    private int expectedNumAssertions;
    private int expectedNumEncryptedAssertions;

    public ResponseTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/core/impl/Response.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/core/impl/ResponseOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/core/impl/ResponseChildElements.xml";
    }

    @Override
    @BeforeMethod
    protected void setUp() throws Exception {
        super.setUp();
        this.expectedNumAssertions = 3;
        this.expectedNumEncryptedAssertions = 2;
    }

    @Override
    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "Response", "saml2p");
        Response resp = (Response)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)resp);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)resp);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME);
        ((Response)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "Response", "saml2p");
        Response resp = (Response)this.buildXMLObject(qname);
        super.populateRequiredAttributes((SAMLObject)resp);
        super.populateOptionalAttributes((SAMLObject)resp);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)resp);
    }

    @Test
    public void testChildElementsMarshall() {
        Response resp = (Response)this.buildXMLObject(Response.DEFAULT_ELEMENT_NAME);
        super.populateChildElements((SAMLObject)resp);
        resp.getAssertions().add((Assertion)this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME));
        resp.getAssertions().add((Assertion)this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME));
        resp.getEncryptedAssertions().add((EncryptedAssertion)this.buildXMLObject(EncryptedAssertion.DEFAULT_ELEMENT_NAME));
        resp.getEncryptedAssertions().add((EncryptedAssertion)this.buildXMLObject(EncryptedAssertion.DEFAULT_ELEMENT_NAME));
        resp.getAssertions().add((Assertion)this.buildXMLObject(Assertion.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)resp);
    }

    @Override
    @Test
    public void testSingleElementUnmarshall() {
        Response resp = (Response)this.unmarshallElement(this.singleElementFile);
        Assert.assertNotNull((Object)resp, (String)"Response was null");
        super.helperTestSingleElementUnmarshall((SAMLObject)resp);
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        Response resp = (Response)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertNotNull((Object)resp, (String)"Response was null");
        super.helperTestSingleElementOptionalAttributesUnmarshall((SAMLObject)resp);
    }

    @Test
    public void testChildElementsUnmarshall() {
        Response resp = (Response)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)resp.getAssertions().size(), (int)this.expectedNumAssertions, (String)"Assertion count");
        Assert.assertEquals((int)resp.getEncryptedAssertions().size(), (int)this.expectedNumEncryptedAssertions, (String)"EncryptedAssertion count");
        super.helperTestChildElementsUnmarshall((SAMLObject)resp);
    }

    @Test(expectedExceptions={UnmarshallingException.class})
    public void testBadSAMLVersion() throws XMLParserException, UnmarshallingException {
        this.unmarshallElement("/org/opensaml/saml/saml2/core/impl/ResponseBadSAMLVersion.xml", true);
    }
}

