/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.core.impl;

import java.time.Instant;
import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.saml.common.SAMLObject;
import org.opensaml.saml.common.SAMLVersion;
import org.opensaml.saml.saml2.core.Issuer;
import org.opensaml.saml.saml2.core.Status;
import org.opensaml.saml.saml2.core.StatusResponseType;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public abstract class StatusResponseTestBase
extends XMLObjectProviderBaseTestCase {
    protected String expectedID;
    protected String expectedInResponseTo;
    protected SAMLVersion expectedSAMLVersion;
    protected Instant expectedIssueInstant;
    protected String expectedDestination;
    protected String expectedConsent;
    protected Issuer expectedIssuer;
    protected Status expectedStatus;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedID = "def456";
        this.expectedInResponseTo = "abc123";
        this.expectedSAMLVersion = SAMLVersion.VERSION_20;
        this.expectedIssueInstant = Instant.parse("2006-02-21T16:40:00.000Z");
        this.expectedDestination = "http://sp.example.org/endpoint";
        this.expectedConsent = "urn:string:consent";
        QName issuerQName = new QName("urn:oasis:names:tc:SAML:2.0:assertion", "Issuer", "saml2");
        this.expectedIssuer = (Issuer)this.buildXMLObject(issuerQName);
        QName statusQName = new QName("urn:oasis:names:tc:SAML:2.0:protocol", "Status", "saml2p");
        this.expectedStatus = (Status)this.buildXMLObject(statusQName);
    }

    @Test
    public abstract void testSingleElementUnmarshall();

    @Test
    public abstract void testSingleElementMarshall();

    protected void populateRequiredAttributes(SAMLObject samlObject) {
        StatusResponseType sr = (StatusResponseType)samlObject;
        sr.setID(this.expectedID);
        sr.setIssueInstant(this.expectedIssueInstant);
    }

    protected void populateOptionalAttributes(SAMLObject samlObject) {
        StatusResponseType sr = (StatusResponseType)samlObject;
        sr.setInResponseTo(this.expectedInResponseTo);
        sr.setConsent(this.expectedConsent);
        sr.setDestination(this.expectedDestination);
    }

    protected void populateChildElements(SAMLObject samlObject) {
        StatusResponseType sr = (StatusResponseType)samlObject;
        sr.setIssuer(this.expectedIssuer);
        sr.setStatus(this.expectedStatus);
    }

    protected void helperTestSingleElementUnmarshall(SAMLObject samlObject) {
        StatusResponseType sr = (StatusResponseType)samlObject;
        Assert.assertEquals((String)sr.getID(), (String)this.expectedID, (String)"Unmarshalled ID attribute was not the expected value");
        Assert.assertEquals((String)sr.getVersion().toString(), (String)this.expectedSAMLVersion.toString(), (String)"Unmarshalled Version attribute was not the expected value");
        Assert.assertEquals((int)this.expectedIssueInstant.compareTo(sr.getIssueInstant()), (int)0, (String)"Unmarshalled IssueInstant attribute was not the expected value");
        Assert.assertNull((Object)sr.getInResponseTo(), (String)"InResponseTo was not null");
        Assert.assertNull((Object)sr.getConsent(), (String)"Consent was not null");
        Assert.assertNull((Object)sr.getDestination(), (String)"Destination was not null");
    }

    protected void helperTestSingleElementOptionalAttributesUnmarshall(SAMLObject samlObject) {
        StatusResponseType sr = (StatusResponseType)samlObject;
        Assert.assertEquals((String)sr.getID(), (String)this.expectedID, (String)"Unmarshalled ID attribute was not the expected value");
        Assert.assertEquals((String)sr.getVersion().toString(), (String)this.expectedSAMLVersion.toString(), (String)"Unmarshalled Version attribute was not the expected value");
        Assert.assertEquals((int)this.expectedIssueInstant.compareTo(sr.getIssueInstant()), (int)0, (String)"Unmarshalled IssueInstant attribute was not the expected value");
        Assert.assertEquals((String)sr.getInResponseTo(), (String)this.expectedInResponseTo, (String)"Unmarshalled InResponseTo attribute was not the expected value");
        Assert.assertEquals((String)sr.getConsent(), (String)this.expectedConsent, (String)"Unmarshalled Consent attribute was not the expected value");
        Assert.assertEquals((String)sr.getDestination(), (String)this.expectedDestination, (String)"Unmarshalled Destination attribute was not the expected value");
    }

    protected void helperTestChildElementsUnmarshall(SAMLObject samlObject) {
        StatusResponseType sr = (StatusResponseType)samlObject;
        Assert.assertNotNull((Object)sr.getIssuer(), (String)"Issuer was null");
        Assert.assertNotNull((Object)sr.getIssuer(), (String)"Status was null");
    }
}

