/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.encryption.tests;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.KeyPair;
import java.security.PublicKey;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.security.spec.AlgorithmParameterSpec;
import java.security.spec.ECGenParameterSpec;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.shibboleth.utilities.java.support.codec.EncodingException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import net.shibboleth.utilities.java.support.resolver.Criterion;
import net.shibboleth.utilities.java.support.xml.ParserPool;
import net.shibboleth.utilities.java.support.xml.SerializeSupport;
import org.opensaml.core.config.ConfigurationService;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.util.XMLObjectSupport;
import org.opensaml.saml.common.testing.SAMLTestSupport;
import org.opensaml.saml.criterion.RoleDescriptorCriterion;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.EncryptedAssertion;
import org.opensaml.saml.saml2.encryption.Decrypter;
import org.opensaml.saml.saml2.encryption.Encrypter;
import org.opensaml.saml.saml2.metadata.EncryptionMethod;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.KeyDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.security.SAMLMetadataKeyAgreementEncryptionConfiguration;
import org.opensaml.saml.security.impl.MetadataCredentialResolver;
import org.opensaml.saml.security.impl.SAMLMetadataEncryptionParametersResolver;
import org.opensaml.security.credential.BasicCredential;
import org.opensaml.security.credential.Credential;
import org.opensaml.security.credential.CredentialResolver;
import org.opensaml.security.credential.UsageType;
import org.opensaml.security.credential.impl.CollectionCredentialResolver;
import org.opensaml.security.crypto.KeySupport;
import org.opensaml.xmlsec.DecryptionConfiguration;
import org.opensaml.xmlsec.DecryptionParameters;
import org.opensaml.xmlsec.DecryptionParametersResolver;
import org.opensaml.xmlsec.EncryptionConfiguration;
import org.opensaml.xmlsec.EncryptionParameters;
import org.opensaml.xmlsec.EncryptionParametersResolver;
import org.opensaml.xmlsec.criterion.DecryptionConfigurationCriterion;
import org.opensaml.xmlsec.criterion.EncryptionConfigurationCriterion;
import org.opensaml.xmlsec.derivation.impl.PBKDF2;
import org.opensaml.xmlsec.encryption.AgreementMethod;
import org.opensaml.xmlsec.encryption.EncryptedKey;
import org.opensaml.xmlsec.encryption.KeyDerivationMethod;
import org.opensaml.xmlsec.encryption.support.DataEncryptionParameters;
import org.opensaml.xmlsec.encryption.support.KeyEncryptionParameters;
import org.opensaml.xmlsec.impl.BasicDecryptionConfiguration;
import org.opensaml.xmlsec.impl.BasicDecryptionParametersResolver;
import org.opensaml.xmlsec.impl.BasicEncryptionConfiguration;
import org.opensaml.xmlsec.keyinfo.KeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.KeyInfoSupport;
import org.opensaml.xmlsec.keyinfo.impl.LocalKeyInfoCredentialResolver;
import org.opensaml.xmlsec.keyinfo.impl.provider.AgreementMethodKeyInfoProvider;
import org.opensaml.xmlsec.signature.KeyInfo;
import org.opensaml.xmlsec.testing.XMLSecurityTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ECDHTest
extends XMLObjectBaseTestCase {
    private String targetFile;
    private Credential recipientCredPrivate;
    private Credential recipientCredPublic;
    private String recipientCredKeyName = "RecipientCredName";
    private CollectionCredentialResolver localCredentialResolver;
    private LocalKeyInfoCredentialResolver localKeyInfoResolver;
    private Encrypter encrypter;
    private EncryptionParametersResolver encParamsResolver;
    private CriteriaSet encCriteria;
    private BasicEncryptionConfiguration encConfig;
    private DecryptionParametersResolver decryptParamsResolver;
    private CriteriaSet decryptCriteria;
    private BasicDecryptionConfiguration decryptConfig;
    private MetadataCredentialResolver mdCredResolver;
    private RoleDescriptorCriterion roleDescCriterion;
    private RoleDescriptor roleDesc;
    private String targetEntityID = "urn:test:foo";

    @BeforeClass
    public void beforeClass() throws Exception {
        this.targetFile = "/org/opensaml/saml/saml2/encryption/Assertion.xml";
        KeyPair kp = KeySupport.generateKeyPair((String)"EC", (AlgorithmParameterSpec)new ECGenParameterSpec("secp256r1"), null);
        this.recipientCredPrivate = new BasicCredential(kp.getPublic(), kp.getPrivate());
        this.recipientCredPublic = new BasicCredential(kp.getPublic());
        this.mdCredResolver = new MetadataCredentialResolver();
        this.mdCredResolver.setKeyInfoCredentialResolver(SAMLTestSupport.buildBasicInlineKeyInfoResolver());
        this.mdCredResolver.initialize();
        this.encParamsResolver = new SAMLMetadataEncryptionParametersResolver(this.mdCredResolver);
        this.decryptParamsResolver = new BasicDecryptionParametersResolver();
        this.localCredentialResolver = new CollectionCredentialResolver(Set.of(this.recipientCredPrivate));
        ArrayList<AgreementMethodKeyInfoProvider> keyInfoProviders = new ArrayList<AgreementMethodKeyInfoProvider>(XMLSecurityTestingSupport.getBasicInlineKeyInfoProviders());
        keyInfoProviders.add(new AgreementMethodKeyInfoProvider());
        this.localKeyInfoResolver = new LocalKeyInfoCredentialResolver(keyInfoProviders, (CredentialResolver)this.localCredentialResolver);
    }

    @BeforeMethod
    public void beforeMethod() throws Exception {
        this.roleDesc = this.buildRoleDescriptorSkeleton();
        this.roleDescCriterion = new RoleDescriptorCriterion(this.roleDesc);
        this.encConfig = new BasicEncryptionConfiguration();
        EncryptionConfigurationCriterion encConfCrit = new EncryptionConfigurationCriterion(new EncryptionConfiguration[]{this.encConfig, (EncryptionConfiguration)ConfigurationService.get(EncryptionConfiguration.class)});
        this.encCriteria = new CriteriaSet(new Criterion[]{encConfCrit, this.roleDescCriterion});
        this.decryptConfig = new BasicDecryptionConfiguration();
        this.decryptConfig.setDataKeyInfoCredentialResolver((KeyInfoCredentialResolver)this.localKeyInfoResolver);
        this.decryptConfig.setKEKKeyInfoCredentialResolver((KeyInfoCredentialResolver)this.localKeyInfoResolver);
        this.decryptCriteria = new CriteriaSet(new Criterion[]{new DecryptionConfigurationCriterion(new DecryptionConfiguration[]{this.decryptConfig, (DecryptionConfiguration)ConfigurationService.get(DecryptionConfiguration.class)})});
    }

    @Test
    public void roundtripDirectDataEncryption() throws Exception {
        KeyDescriptor kd = this.buildKeyDescriptor(this.recipientCredKeyName, UsageType.ENCRYPTION, this.recipientCredPublic.getPublicKey());
        this.roleDesc.getKeyDescriptors().add(kd);
        this.testRoundtrip("http://www.w3.org/2001/04/xmlenc#aes128-cbc", null);
    }

    @Test
    public void roundtripDirectDataEncryptionWithEncryptionMethod() throws Exception {
        KeyDescriptor kd = this.buildKeyDescriptor(this.recipientCredKeyName, UsageType.ENCRYPTION, this.recipientCredPublic.getPublicKey());
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        this.roleDesc.getKeyDescriptors().add(kd);
        this.testRoundtrip("http://www.w3.org/2009/xmlenc11#aes256-gcm", null);
    }

    @Test
    public void roundtripWithKeyWrapAlways() throws Exception {
        KeyDescriptor kd = this.buildKeyDescriptor(this.recipientCredKeyName, UsageType.ENCRYPTION, this.recipientCredPublic.getPublicKey());
        this.roleDesc.getKeyDescriptors().add(kd);
        SAMLMetadataKeyAgreementEncryptionConfiguration kaConfig = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        kaConfig.setMetadataUseKeyWrap(SAMLMetadataKeyAgreementEncryptionConfiguration.KeyWrap.Always);
        this.encConfig.setKeyAgreementConfigurations(Map.of("EC", kaConfig));
        this.testRoundtrip("http://www.w3.org/2001/04/xmlenc#aes128-cbc", "http://www.w3.org/2001/04/xmlenc#kw-aes128");
    }

    @Test
    public void roundtripWithKeyWrapAndEncryptionMethods() throws Exception {
        KeyDescriptor kd = this.buildKeyDescriptor(this.recipientCredKeyName, UsageType.ENCRYPTION, this.recipientCredPublic.getPublicKey());
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2009/xmlenc11#aes128-gcm"));
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#kw-aes256"));
        this.roleDesc.getKeyDescriptors().add(kd);
        this.testRoundtrip("http://www.w3.org/2009/xmlenc11#aes128-gcm", "http://www.w3.org/2001/04/xmlenc#kw-aes256");
    }

    @Test
    public void roundtripWithPBKDF2() throws Exception {
        KeyDescriptor kd = this.buildKeyDescriptor(this.recipientCredKeyName, UsageType.ENCRYPTION, this.recipientCredPublic.getPublicKey());
        this.roleDesc.getKeyDescriptors().add(kd);
        SAMLMetadataKeyAgreementEncryptionConfiguration kaConfig = new SAMLMetadataKeyAgreementEncryptionConfiguration();
        PBKDF2 kdf = new PBKDF2();
        kdf.initialize();
        kaConfig.setParameters(Set.of(kdf));
        this.encConfig.setKeyAgreementConfigurations(Map.of("EC", kaConfig));
        this.testRoundtrip("http://www.w3.org/2001/04/xmlenc#aes128-cbc", null, "http://www.w3.org/2009/xmlenc11#pbkdf2");
    }

    @Test
    public void roundtripWithKeyPlacementPeer() throws Exception {
        KeyDescriptor kd = this.buildKeyDescriptor(this.recipientCredKeyName, UsageType.ENCRYPTION, this.recipientCredPublic.getPublicKey());
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2009/xmlenc11#aes256-gcm"));
        kd.getEncryptionMethods().add(this.buildEncryptionMethod("http://www.w3.org/2001/04/xmlenc#kw-aes256"));
        this.roleDesc.getKeyDescriptors().add(kd);
        this.testRoundtrip("http://www.w3.org/2009/xmlenc11#aes256-gcm", "http://www.w3.org/2001/04/xmlenc#kw-aes256", Encrypter.KeyPlacement.PEER);
    }

    private void testRoundtrip(String expectedDataAlgo, String expectedKEKAlgo, Encrypter.KeyPlacement keyPlacement) throws Exception {
        this.testRoundtrip(expectedDataAlgo, expectedKEKAlgo, null, keyPlacement);
    }

    private void testRoundtrip(String expectedDataAlgo, String expectedKEKAlgo) throws Exception {
        this.testRoundtrip(expectedDataAlgo, expectedKEKAlgo, null, Encrypter.KeyPlacement.INLINE);
    }

    private void testRoundtrip(String expectedDataAlgo, String expectedKEKAlgo, String expectedKDFAlgo) throws Exception {
        this.testRoundtrip(expectedDataAlgo, expectedKEKAlgo, expectedKEKAlgo, Encrypter.KeyPlacement.INLINE);
    }

    private void testRoundtrip(String expectedDataAlgo, String expectedKEKAlgo, String expectedKDFAlgo, Encrypter.KeyPlacement keyPlacement) throws Exception {
        Assertion assertionOrig = (Assertion)this.unmarshallElement(this.targetFile);
        EncryptionParameters encParams = (EncryptionParameters)this.encParamsResolver.resolveSingle((Object)this.encCriteria);
        Assert.assertNotNull((Object)encParams);
        DataEncryptionParameters dataEncParams = new DataEncryptionParameters(encParams);
        List kekParams = encParams.getKeyTransportEncryptionCredential() != null ? List.of(new KeyEncryptionParameters(encParams, null)) : Collections.emptyList();
        this.encrypter = new Encrypter(dataEncParams, kekParams);
        this.encrypter.setKeyPlacement(keyPlacement);
        EncryptedAssertion encryptedAssertionOrig = this.encrypter.encrypt(assertionOrig);
        Assert.assertNotNull((Object)encryptedAssertionOrig);
        Assert.assertNotNull((Object)encryptedAssertionOrig.getEncryptedData().getKeyInfo());
        if (expectedDataAlgo != null) {
            Assert.assertEquals((String)encryptedAssertionOrig.getEncryptedData().getEncryptionMethod().getAlgorithm(), (String)expectedDataAlgo);
        }
        EncryptedKey encryptedKey = null;
        switch (keyPlacement) {
            case INLINE: {
                encryptedKey = !encryptedAssertionOrig.getEncryptedData().getKeyInfo().getEncryptedKeys().isEmpty() ? (EncryptedKey)encryptedAssertionOrig.getEncryptedData().getKeyInfo().getEncryptedKeys().get(0) : null;
                break;
            }
            case PEER: {
                EncryptedKey encryptedKey2 = encryptedKey = !encryptedAssertionOrig.getEncryptedKeys().isEmpty() ? (EncryptedKey)encryptedAssertionOrig.getEncryptedKeys().get(0) : null;
            }
        }
        if (expectedKEKAlgo != null) {
            Assert.assertNotNull(encryptedKey);
            Assert.assertEquals((String)encryptedKey.getEncryptionMethod().getAlgorithm(), (String)expectedKEKAlgo);
        }
        if (expectedKDFAlgo != null) {
            KeyDerivationMethod kdm = null;
            kdm = encryptedKey != null ? (KeyDerivationMethod)((AgreementMethod)encryptedKey.getKeyInfo().getAgreementMethods().get(0)).getUnknownXMLObjects(KeyDerivationMethod.DEFAULT_ELEMENT_NAME).get(0) : (KeyDerivationMethod)((AgreementMethod)encryptedAssertionOrig.getEncryptedData().getKeyInfo().getAgreementMethods().get(0)).getUnknownXMLObjects(KeyDerivationMethod.DEFAULT_ELEMENT_NAME).get(0);
            Assert.assertNotNull((Object)kdm);
            Assert.assertEquals((String)kdm.getAlgorithm(), (String)expectedKDFAlgo);
        }
        Element domEncrypted = XMLObjectSupport.marshall((XMLObject)encryptedAssertionOrig);
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        SerializeSupport.writeNode((Node)domEncrypted, (OutputStream)baos);
        baos.flush();
        byte[] bytesEncrypted = baos.toByteArray();
        ByteArrayInputStream bais = new ByteArrayInputStream(bytesEncrypted);
        EncryptedAssertion encryptedAssertion = (EncryptedAssertion)XMLObjectSupport.unmarshallFromInputStream((ParserPool)XMLObjectProviderRegistrySupport.getParserPool(), (InputStream)bais);
        Assert.assertNotNull((Object)encryptedAssertion);
        DecryptionParameters decryptParams = (DecryptionParameters)this.decryptParamsResolver.resolveSingle((Object)this.decryptCriteria);
        Decrypter decrypter = new Decrypter(decryptParams);
        Assertion decryptedAssertion = decrypter.decrypt(encryptedAssertion);
        Assert.assertNotNull((Object)decryptedAssertion);
        this.assertXMLEquals(assertionOrig.getDOM().getOwnerDocument(), (XMLObject)decryptedAssertion);
    }

    private RoleDescriptor buildRoleDescriptorSkeleton() {
        EntityDescriptor entityDesc = (EntityDescriptor)this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        entityDesc.setEntityID(this.targetEntityID);
        SPSSODescriptor spSSODesc = (SPSSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        spSSODesc.setParent((XMLObject)entityDesc);
        return spSSODesc;
    }

    private KeyDescriptor buildKeyDescriptor(String keyName, UsageType use, Object ... contentItems) {
        KeyDescriptor keyDesc = (KeyDescriptor)this.buildXMLObject(KeyDescriptor.DEFAULT_ELEMENT_NAME);
        KeyInfo keyInfo = (KeyInfo)this.buildXMLObject(KeyInfo.DEFAULT_ELEMENT_NAME);
        for (Object contentItem : contentItems) {
            if (contentItem instanceof PublicKey) {
                try {
                    KeyInfoSupport.addPublicKey((KeyInfo)keyInfo, (PublicKey)((PublicKey)contentItem));
                    continue;
                }
                catch (EncodingException e) {
                    throw new RuntimeException("EncodingException adding public key to KeyInfo", e);
                }
            }
            if (contentItem instanceof X509Certificate) {
                try {
                    KeyInfoSupport.addCertificate((KeyInfo)keyInfo, (X509Certificate)((X509Certificate)contentItem));
                    continue;
                }
                catch (CertificateEncodingException e) {
                    throw new RuntimeException("CertificateEncodingException ading cert to KeyInfo", e);
                }
            }
            throw new RuntimeException("Saw unknown KeyInfo content type: " + contentItem.getClass().getName());
        }
        if (keyName != null) {
            KeyInfoSupport.addKeyName((KeyInfo)keyInfo, (String)keyName);
        }
        keyDesc.setKeyInfo(keyInfo);
        if (use != null) {
            keyDesc.setUse(use);
        }
        return keyDesc;
    }

    private EncryptionMethod buildEncryptionMethod(String algorithm) {
        EncryptionMethod encMethod = (EncryptionMethod)this.buildXMLObject(EncryptionMethod.DEFAULT_ELEMENT_NAME);
        encMethod.setAlgorithm(algorithm);
        return encMethod;
    }
}

