/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.AssertionIDRequestService;
import org.opensaml.saml.saml2.metadata.impl.AssertionIDRequestServiceBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AssertionIDRequestServiceTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedBinding;
    protected String expectedLocation;
    protected String expectedResponseLocation;

    public AssertionIDRequestServiceTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/AssertionIDRequestService.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/AssertionIDRequestServiceOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedBinding = "urn:binding:foo";
        this.expectedLocation = "example.org";
        this.expectedResponseLocation = "example.org/response";
    }

    @Test
    public void testSingleElementUnmarshall() {
        AssertionIDRequestService service = (AssertionIDRequestService)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)service.getBinding(), (String)this.expectedBinding, (String)"Binding URI was not expected value");
        Assert.assertEquals((String)service.getLocation(), (String)this.expectedLocation, (String)"Location was not expected value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AssertionIDRequestService service = (AssertionIDRequestService)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)service.getBinding(), (String)this.expectedBinding, (String)"Binding URI was not expected value");
        Assert.assertEquals((String)service.getLocation(), (String)this.expectedLocation, (String)"Location was not expected value");
        Assert.assertEquals((String)service.getResponseLocation(), (String)this.expectedResponseLocation, (String)"ResponseLocation was not expected value");
        Assert.assertEquals((int)service.getUnknownXMLObjects(AssertionIDRequestService.DEFAULT_ELEMENT_NAME).size(), (int)0);
    }

    @Test
    public void testSingleElementMarshall() {
        AssertionIDRequestService service = (AssertionIDRequestService)this.buildXMLObject(AssertionIDRequestService.DEFAULT_ELEMENT_NAME);
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)service);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        AssertionIDRequestService service = new AssertionIDRequestServiceBuilder().buildObject();
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        service.setResponseLocation(this.expectedResponseLocation);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)service);
    }
}

