/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.saml.saml2.metadata.AttributeService;
import org.opensaml.saml.saml2.metadata.impl.AttributeServiceBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class AttributeServiceTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedBinding;
    protected String expectedLocation;
    protected String expectedResponseLocation;

    public AttributeServiceTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/AttributeService.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/AttributeServiceOptionalAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedBinding = "urn:binding:foo";
        this.expectedLocation = "example.org";
        this.expectedResponseLocation = "example.org/response";
    }

    @Test
    public void testSingleElementUnmarshall() {
        AttributeService service = (AttributeService)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)service.getBinding(), (String)this.expectedBinding, (String)"Binding URI was not expected value");
        Assert.assertEquals((String)service.getLocation(), (String)this.expectedLocation, (String)"Location was not expected value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        AttributeService service = (AttributeService)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((String)service.getBinding(), (String)this.expectedBinding, (String)"Binding URI was not expected value");
        Assert.assertEquals((String)service.getLocation(), (String)this.expectedLocation, (String)"Location was not expected value");
        Assert.assertEquals((String)service.getResponseLocation(), (String)this.expectedResponseLocation, (String)"ResponseLocation was not expected value");
    }

    @Test
    public void testSingleElementMarshall() {
        AttributeService service = new AttributeServiceBuilder().buildObject();
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)service);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AttributeService", "md");
        AttributeService service = (AttributeService)this.buildXMLObject(qname);
        service.setBinding(this.expectedBinding);
        service.setLocation(this.expectedLocation);
        service.setResponseLocation(this.expectedResponseLocation);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)service);
    }
}

