/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.saml.saml2.metadata.EntitiesDescriptor;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.xmlsec.signature.Signature;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EntitiesDescriptorTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedName;
    protected String expectedID;
    protected Duration expectedCacheDuration;
    protected Instant expectedValidUntil;
    protected int expectedEntitiesDescriptorsCount;
    protected int expectedEntityDescriptorsCount;

    public EntitiesDescriptorTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/EntitiesDescriptor.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/EntitiesDescriptorOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/EntitiesDescriptorChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedID = "id";
        this.expectedName = "eDescName";
        this.expectedCacheDuration = Duration.ofSeconds(90L);
        this.expectedValidUntil = Instant.parse("2005-12-07T10:21:00.000Z");
        this.expectedEntitiesDescriptorsCount = 3;
        this.expectedEntityDescriptorsCount = 2;
    }

    @Test
    public void testSingleElementUnmarshall() {
        EntitiesDescriptor entitiesDescriptorObj = (EntitiesDescriptor)this.unmarshallElement(this.singleElementFile);
        String name = entitiesDescriptorObj.getName();
        Assert.assertNull((Object)name, (String)("Name attribute has a value of " + name + ", expected no value"));
        Duration duration = entitiesDescriptorObj.getCacheDuration();
        Assert.assertNull((Object)duration, (String)("cacheDuration attribute has a value of " + duration + ", expected no value"));
        Instant validUntil = entitiesDescriptorObj.getValidUntil();
        Assert.assertNull((Object)validUntil, (String)("validUntil attribute has a value of " + validUntil + ", expected no value"));
        Assert.assertTrue((boolean)entitiesDescriptorObj.isValid());
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        EntitiesDescriptor entitiesDescriptorObj = (EntitiesDescriptor)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        String name = entitiesDescriptorObj.getName();
        Assert.assertEquals((String)name, (String)this.expectedName, (String)("Name attribute has a value of " + name + ", expected a value of " + this.expectedName));
        String id = entitiesDescriptorObj.getID();
        Assert.assertEquals((String)id, (String)this.expectedID, (String)("ID attriubte has a value of " + id + ", expected a value of " + this.expectedID));
        Duration duration = entitiesDescriptorObj.getCacheDuration();
        Assert.assertEquals((Object)duration, (Object)this.expectedCacheDuration, (String)("cacheDuration attribute has a value of " + duration + ", expected a value of " + this.expectedCacheDuration));
        Instant validUntil = entitiesDescriptorObj.getValidUntil();
        Assert.assertEquals((int)this.expectedValidUntil.compareTo(validUntil), (int)0, (String)"validUntil attribute value did not match expected value");
        Assert.assertFalse((boolean)entitiesDescriptorObj.isValid());
    }

    @Test
    public void testChildElementsUnmarshall() {
        EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)entitiesDescriptor.getSignature(), (String)"Signature");
        Assert.assertNotNull((Object)entitiesDescriptor.getExtensions(), (String)"Extensions");
        Assert.assertEquals((int)entitiesDescriptor.getEntitiesDescriptors().size(), (int)this.expectedEntitiesDescriptorsCount, (String)"Entities Descriptor child elements");
        Assert.assertEquals((int)entitiesDescriptor.getEntityDescriptors().size(), (int)this.expectedEntityDescriptorsCount, (String)"Entity Descriptor child elements");
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EntitiesDescriptor", "md");
        EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)this.buildXMLObject(qname);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)entitiesDescriptor);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(EntitiesDescriptor.DEFAULT_ELEMENT_NAME);
        ((EntitiesDescriptor)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EntitiesDescriptor", "md");
        EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)this.buildXMLObject(qname);
        entitiesDescriptor.setName(this.expectedName);
        entitiesDescriptor.setID(this.expectedID);
        entitiesDescriptor.setCacheDuration(this.expectedCacheDuration);
        entitiesDescriptor.setValidUntil(this.expectedValidUntil);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)entitiesDescriptor);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EntitiesDescriptor", "md");
        EntitiesDescriptor entitiesDescriptor = (EntitiesDescriptor)this.buildXMLObject(qname);
        entitiesDescriptor.setID(this.expectedID);
        entitiesDescriptor.setSignature(this.buildSignatureSkeleton());
        QName extensionsQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Extensions", "md");
        entitiesDescriptor.setExtensions((Extensions)this.buildXMLObject(extensionsQName));
        QName entitiesDescriptorQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EntitiesDescriptor", "md");
        QName entityDescriptorQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor", "md");
        entitiesDescriptor.getEntitiesDescriptors().add((EntitiesDescriptor)this.buildXMLObject(entitiesDescriptorQName));
        entitiesDescriptor.getEntityDescriptors().add((EntityDescriptor)this.buildXMLObject(entityDescriptorQName));
        entitiesDescriptor.getEntitiesDescriptors().add((EntitiesDescriptor)this.buildXMLObject(entitiesDescriptorQName));
        entitiesDescriptor.getEntityDescriptors().add((EntityDescriptor)this.buildXMLObject(entityDescriptorQName));
        entitiesDescriptor.getEntitiesDescriptors().add((EntitiesDescriptor)this.buildXMLObject(entitiesDescriptorQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)entitiesDescriptor);
    }

    private Signature buildSignatureSkeleton() {
        Signature signature = (Signature)this.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        return signature;
    }
}

