/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import javax.xml.namespace.QName;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.io.MarshallingException;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.saml.saml2.metadata.AdditionalMetadataLocation;
import org.opensaml.saml.saml2.metadata.AffiliationDescriptor;
import org.opensaml.saml.saml2.metadata.AttributeAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.AuthnAuthorityDescriptor;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.EntityDescriptor;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.PDPDescriptor;
import org.opensaml.saml.saml2.metadata.RoleDescriptor;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.impl.EntityDescriptorBuilder;
import org.opensaml.xmlsec.signature.Signature;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class EntityDescriptorTest
extends XMLObjectProviderBaseTestCase {
    protected String expectedEntityID;
    protected String expectedID;
    protected Duration expectedCacheDuration;
    protected Instant expectedValidUntil;
    protected QName[] unknownAttributeNames = new QName[]{new QName("urn:foo:bar", "bar", "foo")};
    protected String[] unknownAttributeValues = new String[]{"fred"};

    public EntityDescriptorTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/EntityDescriptor.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/EntityDescriptorOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/EntityDescriptorChildElements.xml";
        this.singleElementUnknownAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/EntityDescriptorUnknownAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedID = "id";
        this.expectedEntityID = "99ff33";
        this.expectedCacheDuration = Duration.ofSeconds(90L);
        this.expectedValidUntil = Instant.parse("2005-12-07T10:21:00Z");
    }

    @Test
    public void testSingleElementUnmarshall() {
        EntityDescriptor descriptor = (EntityDescriptor)this.unmarshallElement(this.singleElementFile);
        String entityID = descriptor.getEntityID();
        Assert.assertEquals((String)entityID, (String)this.expectedEntityID, (String)("entityID attribute has a value of " + entityID + ", expected a value of " + this.expectedEntityID));
        Duration duration = descriptor.getCacheDuration();
        Assert.assertNull((Object)duration, (String)("cacheDuration attribute has a value of " + duration + ", expected no value"));
        Instant validUntil = descriptor.getValidUntil();
        Assert.assertNull((Object)validUntil, (String)("validUntil attribute has a value of " + validUntil + ", expected no value"));
        Assert.assertTrue((boolean)descriptor.isValid());
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        EntityDescriptor descriptor = (EntityDescriptor)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        String entityID = descriptor.getEntityID();
        Assert.assertEquals((String)entityID, (String)this.expectedEntityID, (String)("entityID attribute has a value of " + entityID + ", expected a value of " + this.expectedEntityID));
        String id = descriptor.getID();
        Assert.assertEquals((String)id, (String)this.expectedID, (String)("ID attribute has a value of " + id + ", expected a value of " + this.expectedID));
        Duration duration = descriptor.getCacheDuration();
        Assert.assertEquals((Object)duration, (Object)this.expectedCacheDuration, (String)("cacheDuration attribute has a value of " + duration + ", expected a value of " + this.expectedCacheDuration));
        Instant validUntil = descriptor.getValidUntil();
        Assert.assertEquals((int)this.expectedValidUntil.compareTo(validUntil), (int)0, (String)"validUntil attribute value did not match expected value");
        Assert.assertFalse((boolean)descriptor.isValid());
    }

    @Test
    public void testSingleElementUnknownAttributesUnmarshall() {
        EntityDescriptor descriptor = (EntityDescriptor)this.unmarshallElement(this.singleElementUnknownAttributesFile);
        AttributeMap attributes = descriptor.getUnknownAttributes();
        Assert.assertEquals((int)attributes.entrySet().size(), (int)this.unknownAttributeNames.length);
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            Assert.assertEquals((String)attributes.get((Object)this.unknownAttributeNames[i]), (String)this.unknownAttributeValues[i]);
        }
    }

    @Test
    public void testChildElementsUnmarshall() {
        EntityDescriptor descriptor = (EntityDescriptor)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)descriptor.getExtensions(), (String)"Extensions child");
        Assert.assertNotNull((Object)descriptor.getSignature(), (String)"Signature child");
        Assert.assertEquals((int)descriptor.getRoleDescriptors(IDPSSODescriptor.DEFAULT_ELEMENT_NAME).size(), (int)2, (String)"IDPSSODescriptor count");
        Assert.assertNotNull((Object)descriptor.getIDPSSODescriptor("foo"), (String)"IDPSSODescriptor (protocol)");
        Assert.assertNull((Object)descriptor.getIDPSSODescriptor("bar"), (String)"IDPSSODescriptor (protocol)");
        Assert.assertEquals((int)descriptor.getRoleDescriptors(IDPSSODescriptor.DEFAULT_ELEMENT_NAME, "foo").size(), (int)1, (String)"IDPSSODescriptor (protocol) count");
        Assert.assertEquals((int)descriptor.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME).size(), (int)3, (String)"SPSSODescriptor count");
        Assert.assertEquals((int)descriptor.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME, "foo").size(), (int)1, (String)"SPSSODescriptor (protocol) count");
        Assert.assertNotNull((Object)descriptor.getSPSSODescriptor("foo"), (String)"SPPSSODescriptor (protocol)");
        Assert.assertNull((Object)descriptor.getSPSSODescriptor("bar"), (String)"SPPSSODescriptor (protocol)");
        Assert.assertEquals((int)descriptor.getRoleDescriptors(AuthnAuthorityDescriptor.DEFAULT_ELEMENT_NAME).size(), (int)2, (String)"AuthnAuthorityDescriptor count");
        Assert.assertEquals((int)descriptor.getRoleDescriptors(AuthnAuthorityDescriptor.DEFAULT_ELEMENT_NAME, "foo").size(), (int)1, (String)"AuthnAuthorityDescriptor count");
        Assert.assertNotNull((Object)descriptor.getAuthnAuthorityDescriptor("foo"), (String)"AuthnAuthorityDescriptor (protocol)");
        Assert.assertNull((Object)descriptor.getAuthnAuthorityDescriptor("bar"), (String)"AuthnAuthorityDescriptor (protocol)");
        Assert.assertEquals((int)descriptor.getRoleDescriptors(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME).size(), (int)1, (String)"AttributeAuthorityDescriptor count");
        Assert.assertEquals((int)descriptor.getRoleDescriptors(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME, "foo").size(), (int)1, (String)"AttributeAuthorityDescriptor (protocol) count");
        Assert.assertNotNull((Object)descriptor.getAttributeAuthorityDescriptor("foo"), (String)"AttributeAuthorityDescriptor (protocol)");
        Assert.assertNull((Object)descriptor.getAttributeAuthorityDescriptor("bar"), (String)"AttributeAuthorityDescriptor (protocol)");
        Assert.assertEquals((int)descriptor.getRoleDescriptors(PDPDescriptor.DEFAULT_ELEMENT_NAME).size(), (int)2, (String)"PDPDescriptor count");
        Assert.assertEquals((int)descriptor.getRoleDescriptors(PDPDescriptor.DEFAULT_ELEMENT_NAME, "foo").size(), (int)1, (String)"PDPDescriptor (protocol) count");
        Assert.assertNotNull((Object)descriptor.getPDPDescriptor("foo"), (String)"PDPDescriptor (protocol)");
        Assert.assertNull((Object)descriptor.getPDPDescriptor("bar"), (String)"PDPDescriptor (protocol)");
        Assert.assertNotNull((Object)descriptor.getAffiliationDescriptor(), (String)"AffiliationDescriptor ");
        Assert.assertNotNull((Object)descriptor.getOrganization(), (String)"Organization ");
        Assert.assertEquals((int)descriptor.getContactPersons().size(), (int)1, (String)"ContactPerson count");
        Assert.assertEquals((int)descriptor.getAdditionalMetadataLocations().size(), (int)3, (String)"AdditionalMetadataLocation count");
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor", "md");
        EntityDescriptor descriptor = (EntityDescriptor)this.buildXMLObject(qname);
        StringBuilder bigString = new StringBuilder();
        for (int i = 0; i < 2000; ++i) {
            bigString.append('x');
        }
        try {
            descriptor.setEntityID(bigString.toString());
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        descriptor.setEntityID(this.expectedEntityID);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)descriptor);
    }

    @Test
    public void testAttributeIDnessMarshall() throws MarshallingException, XMLParserException {
        XMLObject target = this.buildXMLObject(EntityDescriptor.DEFAULT_ELEMENT_NAME);
        ((EntityDescriptor)target).setID("id123");
        this.testAttributeIDnessMarshall(target, "id123");
    }

    @Test
    public void testSingleElementUnknownAttributesMarshall() {
        EntityDescriptor descriptor = new EntityDescriptorBuilder().buildObject();
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            descriptor.getUnknownAttributes().put(this.unknownAttributeNames[i], this.unknownAttributeValues[i]);
        }
        this.assertXMLEquals(this.expectedUnknownAttributesDOM, (XMLObject)descriptor);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor", "md");
        EntityDescriptor descriptor = (EntityDescriptor)this.buildXMLObject(qname);
        descriptor.setEntityID(this.expectedEntityID);
        descriptor.setID(this.expectedID);
        descriptor.setValidUntil(this.expectedValidUntil);
        descriptor.setCacheDuration(this.expectedCacheDuration);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)descriptor);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "EntityDescriptor", "md");
        EntityDescriptor descriptor = (EntityDescriptor)this.buildXMLObject(qname);
        descriptor.setID(this.expectedID);
        descriptor.setEntityID(this.expectedEntityID);
        QName extensionsQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Extensions", "md");
        descriptor.setExtensions((Extensions)this.buildXMLObject(extensionsQName));
        descriptor.setSignature(this.buildSignatureSkeleton());
        QName idpSSOQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "IDPSSODescriptor", "md");
        QName spSSOQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SPSSODescriptor", "md");
        QName authnAuthQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AuthnAuthorityDescriptor", "md");
        QName pdpQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "PDPDescriptor", "md");
        QName affilQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AffiliationDescriptor", "md");
        RoleDescriptor desc = (RoleDescriptor)this.buildXMLObject(idpSSOQName);
        desc.addSupportedProtocol("foo");
        descriptor.getRoleDescriptors(IDPSSODescriptor.DEFAULT_ELEMENT_NAME).add(desc);
        desc = (RoleDescriptor)this.buildXMLObject(spSSOQName);
        desc.addSupportedProtocol("foo");
        descriptor.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME).add(desc);
        descriptor.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME).add((SPSSODescriptor)this.buildXMLObject(spSSOQName));
        desc = (RoleDescriptor)this.buildXMLObject(authnAuthQName);
        desc.addSupportedProtocol("foo");
        descriptor.getRoleDescriptors(AuthnAuthorityDescriptor.DEFAULT_ELEMENT_NAME).add(desc);
        desc = (RoleDescriptor)this.buildXMLObject(pdpQName);
        desc.addSupportedProtocol("foo");
        descriptor.getRoleDescriptors(PDPDescriptor.DEFAULT_ELEMENT_NAME).add(desc);
        descriptor.getRoleDescriptors(IDPSSODescriptor.DEFAULT_ELEMENT_NAME).add((IDPSSODescriptor)this.buildXMLObject(idpSSOQName));
        desc = (RoleDescriptor)this.buildXMLObject(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME);
        desc.addSupportedProtocol("foo");
        descriptor.getRoleDescriptors(AttributeAuthorityDescriptor.DEFAULT_ELEMENT_NAME).add(desc);
        descriptor.getRoleDescriptors(SPSSODescriptor.DEFAULT_ELEMENT_NAME).add((SPSSODescriptor)this.buildXMLObject(spSSOQName));
        descriptor.getRoleDescriptors(AuthnAuthorityDescriptor.DEFAULT_ELEMENT_NAME).add((AuthnAuthorityDescriptor)this.buildXMLObject(authnAuthQName));
        descriptor.getRoleDescriptors(PDPDescriptor.DEFAULT_ELEMENT_NAME).add((PDPDescriptor)this.buildXMLObject(pdpQName));
        descriptor.setAffiliationDescriptor((AffiliationDescriptor)this.buildXMLObject(affilQName));
        QName orgQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Organization", "md");
        descriptor.setOrganization((Organization)this.buildXMLObject(orgQName));
        QName contactQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "ContactPerson", "md");
        descriptor.getContactPersons().add((ContactPerson)this.buildXMLObject(contactQName));
        QName addMDQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AdditionalMetadataLocation", "md");
        for (int i = 0; i < 3; ++i) {
            descriptor.getAdditionalMetadataLocations().add((AdditionalMetadataLocation)this.buildXMLObject(addMDQName));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)descriptor);
    }

    private Signature buildSignatureSkeleton() {
        Signature signature = (Signature)this.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        return signature;
    }
}

