/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.core.xml.util.AttributeMap;
import org.opensaml.saml.common.SAMLObjectBuilder;
import org.opensaml.saml.saml2.core.Attribute;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.AssertionIDRequestService;
import org.opensaml.saml.saml2.metadata.AttributeProfile;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.IDPSSODescriptor;
import org.opensaml.saml.saml2.metadata.ManageNameIDService;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.NameIDMappingService;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.SingleSignOnService;
import org.opensaml.saml.saml2.metadata.impl.IDPSSODescriptorBuilder;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class IDPSSODescriptorTest
extends XMLObjectProviderBaseTestCase {
    protected ArrayList<String> expectedSupportedProtocol;
    protected Duration expectedCacheDuration;
    protected Instant expectedValidUntil;
    protected String expectedErrorURL;
    protected XSBooleanValue expectedWantAuthnReqSigned;
    protected QName[] unknownAttributeNames = new QName[]{new QName("urn:foo:bar", "bar", "foo")};
    protected String[] unknownAttributeValues = new String[]{"fred"};

    public IDPSSODescriptorTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/IDPSSODescriptor.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/IDPSSODescriptorOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/IDPSSODescriptorChildElements.xml";
        this.singleElementUnknownAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/IDPSSODescriptorUnknownAttributes.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedSupportedProtocol = new ArrayList();
        this.expectedSupportedProtocol.add("urn:foo:bar");
        this.expectedSupportedProtocol.add("urn:fooz:baz");
        this.expectedCacheDuration = Duration.ofSeconds(90L);
        this.expectedValidUntil = Instant.parse("2005-12-07T10:21:00Z");
        this.expectedErrorURL = "http://example.org";
        this.expectedWantAuthnReqSigned = new XSBooleanValue(Boolean.TRUE, false);
    }

    @Test
    public void testSingleElementUnmarshall() {
        IDPSSODescriptor descriptor = (IDPSSODescriptor)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((Collection)descriptor.getSupportedProtocols(), this.expectedSupportedProtocol, (String)"Supported protocols not equal to expected value");
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        IDPSSODescriptor descriptor = (IDPSSODescriptor)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((Object)descriptor.getCacheDuration(), (Object)this.expectedCacheDuration, (String)"Cache duration was not expected value");
        Assert.assertEquals((Object)descriptor.getValidUntil(), (Object)this.expectedValidUntil, (String)"ValidUntil was not expected value");
        Assert.assertEquals((Object)descriptor.getWantAuthnRequestsSignedXSBoolean(), (Object)this.expectedWantAuthnReqSigned, (String)"WantAuthnRequestsSigned attribute was not expected value");
    }

    @Test
    public void testSingleElementUnknownAttributesMarshall() {
        IDPSSODescriptor descriptor = new IDPSSODescriptorBuilder().buildObject();
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            descriptor.getUnknownAttributes().put(this.unknownAttributeNames[i], this.unknownAttributeValues[i]);
        }
        this.assertXMLEquals(this.expectedUnknownAttributesDOM, (XMLObject)descriptor);
    }

    @Test
    public void testSingleElementUnknownAttributesUnmarshall() {
        IDPSSODescriptor descriptor = (IDPSSODescriptor)this.unmarshallElement(this.singleElementUnknownAttributesFile);
        AttributeMap attributes = descriptor.getUnknownAttributes();
        Assert.assertEquals((int)attributes.entrySet().size(), (int)this.unknownAttributeNames.length);
        for (int i = 0; i < this.unknownAttributeNames.length; ++i) {
            Assert.assertEquals((String)attributes.get((Object)this.unknownAttributeNames[i]), (String)this.unknownAttributeValues[i]);
        }
    }

    @Test
    public void testChildElementsUnmarshall() {
        IDPSSODescriptor descriptor = (IDPSSODescriptor)this.unmarshallElement(this.childElementsFile);
        Assert.assertNotNull((Object)descriptor.getExtensions(), (String)"Extensions");
        Assert.assertNotNull((Object)descriptor.getOrganization(), (String)"Organization child");
        Assert.assertEquals((int)descriptor.getContactPersons().size(), (int)2, (String)"ContactPerson count");
        Assert.assertEquals((int)descriptor.getArtifactResolutionServices().size(), (int)1, (String)"ArtifactResolutionService count");
        Assert.assertEquals((int)descriptor.getSingleLogoutServices().size(), (int)2, (String)"SingleLogoutService count");
        Assert.assertEquals((int)descriptor.getManageNameIDServices().size(), (int)4, (String)"ManageNameIDService count");
        Assert.assertEquals((int)descriptor.getNameIDFormats().size(), (int)1, (String)"NameIDFormat count");
        Assert.assertEquals((int)descriptor.getEndpoints().size(), (int)15, (String)"All Endpoints");
        Assert.assertEquals((int)descriptor.getSingleSignOnServices().size(), (int)3, (String)"SingleSignOnService count");
        Assert.assertEquals((int)descriptor.getEndpoints(SingleSignOnService.DEFAULT_ELEMENT_NAME).size(), (int)3, (String)"SingleSignOnService count");
        Assert.assertEquals((int)descriptor.getNameIDMappingServices().size(), (int)2, (String)"NameIDMappingService count");
        Assert.assertEquals((int)descriptor.getEndpoints(NameIDMappingService.DEFAULT_ELEMENT_NAME).size(), (int)2, (String)"NameIDMappingService count");
        Assert.assertEquals((int)descriptor.getAssertionIDRequestServices().size(), (int)3, (String)"AssertionIDRequestService count");
        Assert.assertEquals((int)descriptor.getEndpoints(AssertionIDRequestService.DEFAULT_ELEMENT_NAME).size(), (int)3, (String)"AssertionIDRequestService count");
        Assert.assertEquals((int)descriptor.getAttributeProfiles().size(), (int)3, (String)"AttributeProfile count");
        Assert.assertEquals((int)descriptor.getAttributes().size(), (int)1);
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "IDPSSODescriptor", "md");
        IDPSSODescriptor descriptor = (IDPSSODescriptor)this.buildXMLObject(qname);
        for (String protocol : this.expectedSupportedProtocol) {
            descriptor.addSupportedProtocol(protocol);
        }
        descriptor.setWantAuthnRequestsSigned(this.expectedWantAuthnReqSigned);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)descriptor);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "IDPSSODescriptor", "md");
        IDPSSODescriptor descriptor = (IDPSSODescriptor)this.buildXMLObject(qname);
        for (String protocol : this.expectedSupportedProtocol) {
            descriptor.addSupportedProtocol(protocol);
        }
        descriptor.setCacheDuration(this.expectedCacheDuration);
        descriptor.setValidUntil(this.expectedValidUntil);
        descriptor.setErrorURL(this.expectedErrorURL);
        descriptor.setWantAuthnRequestsSigned(this.expectedWantAuthnReqSigned);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)descriptor);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "IDPSSODescriptor", "md");
        IDPSSODescriptor descriptor = (IDPSSODescriptor)this.buildXMLObject(qname);
        QName extensionsQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Extensions", "md");
        descriptor.setExtensions((Extensions)this.buildXMLObject(extensionsQName));
        QName orgQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Organization", "md");
        descriptor.setOrganization((Organization)this.buildXMLObject(orgQName));
        QName contactQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "ContactPerson", "md");
        for (int i = 0; i < 2; ++i) {
            descriptor.getContactPersons().add((ContactPerson)this.buildXMLObject(contactQName));
        }
        QName artResQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "ArtifactResolutionService", "md");
        descriptor.getArtifactResolutionServices().add((ArtifactResolutionService)this.buildXMLObject(artResQName));
        QName sloQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SingleLogoutService", "md");
        for (int i = 0; i < 2; ++i) {
            descriptor.getSingleLogoutServices().add((SingleLogoutService)this.buildXMLObject(sloQName));
        }
        QName mngNameIDQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "ManageNameIDService", "md");
        for (int i = 0; i < 4; ++i) {
            descriptor.getManageNameIDServices().add((ManageNameIDService)this.buildXMLObject(mngNameIDQName));
        }
        QName nameIDFormatQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "NameIDFormat", "md");
        descriptor.getNameIDFormats().add((NameIDFormat)this.buildXMLObject(nameIDFormatQName));
        QName ssoQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SingleSignOnService", "md");
        for (int i = 0; i < 3; ++i) {
            descriptor.getSingleSignOnServices().add((SingleSignOnService)this.buildXMLObject(ssoQName));
        }
        QName nameIDMapQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "NameIDMappingService", "md");
        for (int i = 0; i < 2; ++i) {
            descriptor.getNameIDMappingServices().add((NameIDMappingService)this.buildXMLObject(nameIDMapQName));
        }
        QName assertIDReqQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AssertionIDRequestService", "md");
        for (int i = 0; i < 3; ++i) {
            descriptor.getAssertionIDRequestServices().add((AssertionIDRequestService)this.buildXMLObject(assertIDReqQName));
        }
        QName attributeProlfileQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AttributeProfile", "md");
        for (int i = 0; i < 3; ++i) {
            descriptor.getAttributeProfiles().add((AttributeProfile)this.buildXMLObject(attributeProlfileQName));
        }
        SAMLObjectBuilder builder = (SAMLObjectBuilder)XMLObjectProviderRegistrySupport.getBuilderFactory().getBuilderOrThrow(Attribute.DEFAULT_ELEMENT_NAME);
        descriptor.getAttributes().add((Attribute)builder.buildObject());
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)descriptor);
    }

    @Test
    public void testXSBooleanAttributes() {
        IDPSSODescriptor descriptor = (IDPSSODescriptor)this.buildXMLObject(IDPSSODescriptor.DEFAULT_ELEMENT_NAME);
        descriptor.setWantAuthnRequestsSigned(Boolean.TRUE);
        Assert.assertEquals((Object)descriptor.getWantAuthnRequestsSigned(), (Object)Boolean.TRUE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)descriptor.getWantAuthnRequestsSignedXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)descriptor.getWantAuthnRequestsSignedXSBoolean(), (Object)new XSBooleanValue(Boolean.TRUE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)descriptor.getWantAuthnRequestsSignedXSBoolean().toString(), (String)"true", (String)"XSBooleanValue string was unexpected value");
        descriptor.setWantAuthnRequestsSigned(Boolean.FALSE);
        Assert.assertEquals((Object)descriptor.getWantAuthnRequestsSigned(), (Object)Boolean.FALSE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)descriptor.getWantAuthnRequestsSignedXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)descriptor.getWantAuthnRequestsSignedXSBoolean(), (Object)new XSBooleanValue(Boolean.FALSE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)descriptor.getWantAuthnRequestsSignedXSBoolean().toString(), (String)"false", (String)"XSBooleanValue string was unexpected value");
        descriptor.setWantAuthnRequestsSigned((Boolean)null);
        Assert.assertEquals((Object)descriptor.getWantAuthnRequestsSigned(), (Object)Boolean.FALSE, (String)"Unexpected default value for boolean attribute found");
        Assert.assertNull((Object)descriptor.getWantAuthnRequestsSignedXSBoolean(), (String)"XSBooleanValue was not null");
    }
}

