/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.impl;

import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import javax.xml.namespace.QName;
import org.opensaml.core.testing.XMLObjectProviderBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.schema.XSBooleanValue;
import org.opensaml.saml.saml2.metadata.ArtifactResolutionService;
import org.opensaml.saml.saml2.metadata.AssertionConsumerService;
import org.opensaml.saml.saml2.metadata.AttributeConsumingService;
import org.opensaml.saml.saml2.metadata.ContactPerson;
import org.opensaml.saml.saml2.metadata.Extensions;
import org.opensaml.saml.saml2.metadata.ManageNameIDService;
import org.opensaml.saml.saml2.metadata.NameIDFormat;
import org.opensaml.saml.saml2.metadata.Organization;
import org.opensaml.saml.saml2.metadata.SPSSODescriptor;
import org.opensaml.saml.saml2.metadata.SingleLogoutService;
import org.opensaml.saml.saml2.metadata.impl.SPSSODescriptorBuilder;
import org.opensaml.xmlsec.signature.Signature;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SPSSODescriptorTest
extends XMLObjectProviderBaseTestCase {
    protected XSBooleanValue expectedAuthnRequestSigned;
    protected XSBooleanValue expectedWantAssertionsSigned;
    protected ArrayList<String> expectedSupportedProtocol;
    protected Duration expectedCacheDuration;
    protected Instant expectedValidUntil;
    protected String expectedId;

    public SPSSODescriptorTest() {
        this.singleElementFile = "/org/opensaml/saml/saml2/metadata/impl/SPSSODescriptor.xml";
        this.singleElementOptionalAttributesFile = "/org/opensaml/saml/saml2/metadata/impl/SPSSODescriptorOptionalAttributes.xml";
        this.childElementsFile = "/org/opensaml/saml/saml2/metadata/impl/SPSSODescriptorChildElements.xml";
    }

    @BeforeMethod
    protected void setUp() throws Exception {
        this.expectedAuthnRequestSigned = new XSBooleanValue(Boolean.TRUE, false);
        this.expectedWantAssertionsSigned = new XSBooleanValue(Boolean.TRUE, false);
        this.expectedSupportedProtocol = new ArrayList();
        this.expectedSupportedProtocol.add("urn:foo:bar");
        this.expectedSupportedProtocol.add("urn:fooz:baz");
        this.expectedCacheDuration = Duration.ofSeconds(90L);
        this.expectedValidUntil = Instant.parse("2005-12-07T10:21:00Z");
        this.expectedId = "id";
    }

    @Test
    public void testSingleElementUnmarshall() {
        SPSSODescriptor descriptor = (SPSSODescriptor)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((Collection)descriptor.getSupportedProtocols(), this.expectedSupportedProtocol, (String)"Supported protocols not equal to expected value");
        descriptor.removeAllSupportedProtocols();
        Assert.assertEquals((int)descriptor.getSupportedProtocols().size(), (int)0);
        Assert.assertTrue((boolean)descriptor.isValid());
    }

    @Test
    public void testSingleElementOptionalAttributesUnmarshall() {
        SPSSODescriptor descriptor = (SPSSODescriptor)this.unmarshallElement(this.singleElementOptionalAttributesFile);
        Assert.assertEquals((Collection)descriptor.getSupportedProtocols(), this.expectedSupportedProtocol, (String)"Supported protocols not equal to expected value");
        Assert.assertEquals((Object)descriptor.isAuthnRequestsSignedXSBoolean(), (Object)this.expectedAuthnRequestSigned, (String)"AuthnRequestsSigned attribute was not expected value");
        Assert.assertEquals((Object)descriptor.getWantAssertionsSignedXSBoolean(), (Object)this.expectedWantAssertionsSigned, (String)"WantAssertionsSigned attribute was not expected value");
        Assert.assertEquals((Object)descriptor.getValidUntil(), (Object)this.expectedValidUntil, (String)"ValudUntil attribute was not expected value");
        Assert.assertFalse((boolean)descriptor.isValid());
        descriptor.removeSupportedProtocol("urn:foo:bar");
        Assert.assertEquals((int)descriptor.getSupportedProtocols().size(), (int)(this.expectedSupportedProtocol.size() - 1));
        descriptor.removeSupportedProtocols(this.expectedSupportedProtocol);
        Assert.assertEquals((int)descriptor.getSupportedProtocols().size(), (int)0);
    }

    @Test
    public void testChildElementsUnmarshall() {
        SPSSODescriptor descriptor = (SPSSODescriptor)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)descriptor.getID(), (String)this.expectedId);
        Assert.assertEquals((String)descriptor.getSignatureReferenceID(), (String)this.expectedId);
        Assert.assertNotNull((Object)descriptor.getSignature());
        Assert.assertNotNull((Object)descriptor.getExtensions(), (String)"Extensions");
        Assert.assertEquals((int)descriptor.getKeyDescriptors().size(), (int)0, (String)"KeyDescriptor");
        Assert.assertNotNull((Object)descriptor.getOrganization(), (String)"Organization child");
        Assert.assertEquals((int)descriptor.getContactPersons().size(), (int)2, (String)"ContactPerson count");
        Assert.assertEquals((int)descriptor.getArtifactResolutionServices().size(), (int)1, (String)"ArtifactResolutionService count");
        Assert.assertEquals((int)descriptor.getEndpoints(ArtifactResolutionService.DEFAULT_ELEMENT_NAME).size(), (int)1, (String)"ArtifactResolutionServices");
        Assert.assertEquals((int)descriptor.getSingleLogoutServices().size(), (int)2, (String)"SingleLogoutService count");
        Assert.assertEquals((int)descriptor.getEndpoints(SingleLogoutService.DEFAULT_ELEMENT_NAME).size(), (int)2, (String)"SingleLogoutService count");
        Assert.assertEquals((int)descriptor.getManageNameIDServices().size(), (int)4, (String)"ManageNameIDService count");
        Assert.assertEquals((int)descriptor.getEndpoints(ManageNameIDService.DEFAULT_ELEMENT_NAME).size(), (int)4, (String)"ManageNameIDService count");
        Assert.assertEquals((int)descriptor.getNameIDFormats().size(), (int)1, (String)"NameIDFormat count");
        Assert.assertEquals((int)descriptor.getAssertionConsumerServices().size(), (int)2, (String)"AssertionConsumerService count");
        Assert.assertEquals((int)descriptor.getEndpoints(AssertionConsumerService.DEFAULT_ELEMENT_NAME).size(), (int)2, (String)"AssertionConsumerService count");
        Assert.assertEquals((int)descriptor.getAttributeConsumingServices().size(), (int)1, (String)"AttributeConsumingService");
        Assert.assertEquals((int)descriptor.getEndpoints().size(), (int)9);
        Assert.assertNotNull((Object)descriptor.getDefaultArtifactResolutionService());
        Assert.assertNotNull((Object)descriptor.getDefaultAttributeConsumingService());
        Assert.assertNotNull((Object)descriptor.getDefaultAssertionConsumerService());
    }

    @Test
    public void testSingleElementMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SPSSODescriptor", "md");
        SPSSODescriptor descriptor = (SPSSODescriptor)this.buildXMLObject(qname);
        for (String protocol : this.expectedSupportedProtocol) {
            descriptor.addSupportedProtocol(protocol);
        }
        this.assertXMLEquals(this.expectedDOM, (XMLObject)descriptor);
    }

    @Test
    public void testSingleElementOptionalAttributesMarshall() {
        SPSSODescriptor descriptor = new SPSSODescriptorBuilder().buildObject();
        descriptor.setAuthnRequestsSigned(this.expectedAuthnRequestSigned);
        descriptor.setWantAssertionsSigned(this.expectedWantAssertionsSigned);
        for (String protocol : this.expectedSupportedProtocol) {
            descriptor.addSupportedProtocol(protocol);
        }
        descriptor.setCacheDuration(this.expectedCacheDuration);
        descriptor.setValidUntil(this.expectedValidUntil);
        this.assertXMLEquals(this.expectedOptionalAttributesDOM, (XMLObject)descriptor);
    }

    @Test
    public void testChildElementsMarshall() {
        QName qname = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SPSSODescriptor", "md");
        SPSSODescriptor descriptor = (SPSSODescriptor)this.buildXMLObject(qname);
        descriptor.setID(this.expectedId);
        descriptor.setSignature(this.buildSignatureSkeleton());
        QName extensionsQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Extensions", "md");
        descriptor.setExtensions((Extensions)this.buildXMLObject(extensionsQName));
        QName orgQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "Organization", "md");
        descriptor.setOrganization((Organization)this.buildXMLObject(orgQName));
        QName contactQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "ContactPerson", "md");
        for (int i = 0; i < 2; ++i) {
            descriptor.getContactPersons().add((ContactPerson)this.buildXMLObject(contactQName));
        }
        QName artResQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "ArtifactResolutionService", "md");
        descriptor.getArtifactResolutionServices().add((ArtifactResolutionService)this.buildXMLObject(artResQName));
        QName sloQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "SingleLogoutService", "md");
        for (int i = 0; i < 2; ++i) {
            descriptor.getSingleLogoutServices().add((SingleLogoutService)this.buildXMLObject(sloQName));
        }
        QName mngNameIDQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "ManageNameIDService", "md");
        for (int i = 0; i < 4; ++i) {
            descriptor.getManageNameIDServices().add((ManageNameIDService)this.buildXMLObject(mngNameIDQName));
        }
        QName nameIDFormatQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "NameIDFormat", "md");
        descriptor.getNameIDFormats().add((NameIDFormat)this.buildXMLObject(nameIDFormatQName));
        QName assertConsumeQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AssertionConsumerService", "md");
        for (int i = 0; i < 2; ++i) {
            descriptor.getAssertionConsumerServices().add((AssertionConsumerService)this.buildXMLObject(assertConsumeQName));
        }
        QName attribConsumeQName = new QName("urn:oasis:names:tc:SAML:2.0:metadata", "AttributeConsumingService", "md");
        descriptor.getAttributeConsumingServices().add((AttributeConsumingService)this.buildXMLObject(attribConsumeQName));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)descriptor);
    }

    @Test
    public void testXSBooleanAttributes() {
        SPSSODescriptor descriptor = (SPSSODescriptor)this.buildXMLObject(SPSSODescriptor.DEFAULT_ELEMENT_NAME);
        descriptor.setAuthnRequestsSigned(Boolean.TRUE);
        Assert.assertEquals((Object)descriptor.isAuthnRequestsSigned(), (Object)Boolean.TRUE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)descriptor.isAuthnRequestsSignedXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)descriptor.isAuthnRequestsSignedXSBoolean(), (Object)new XSBooleanValue(Boolean.TRUE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)descriptor.isAuthnRequestsSignedXSBoolean().toString(), (String)"true", (String)"XSBooleanValue string was unexpected value");
        descriptor.setAuthnRequestsSigned(Boolean.FALSE);
        Assert.assertEquals((Object)descriptor.isAuthnRequestsSigned(), (Object)Boolean.FALSE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)descriptor.isAuthnRequestsSignedXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)descriptor.isAuthnRequestsSignedXSBoolean(), (Object)new XSBooleanValue(Boolean.FALSE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)descriptor.isAuthnRequestsSignedXSBoolean().toString(), (String)"false", (String)"XSBooleanValue string was unexpected value");
        descriptor.setAuthnRequestsSigned((Boolean)null);
        Assert.assertEquals((Object)descriptor.isAuthnRequestsSigned(), (Object)Boolean.FALSE, (String)"Unexpected default value for boolean attribute found");
        Assert.assertNull((Object)descriptor.isAuthnRequestsSignedXSBoolean(), (String)"XSBooleanValue was not null");
        descriptor.setWantAssertionsSigned(Boolean.TRUE);
        Assert.assertEquals((Object)descriptor.getWantAssertionsSigned(), (Object)Boolean.TRUE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)descriptor.getWantAssertionsSignedXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)descriptor.getWantAssertionsSignedXSBoolean(), (Object)new XSBooleanValue(Boolean.TRUE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)descriptor.getWantAssertionsSignedXSBoolean().toString(), (String)"true", (String)"XSBooleanValue string was unexpected value");
        descriptor.setWantAssertionsSigned(Boolean.FALSE);
        Assert.assertEquals((Object)descriptor.getWantAssertionsSigned(), (Object)Boolean.FALSE, (String)"Unexpected value for boolean attribute found");
        Assert.assertNotNull((Object)descriptor.getWantAssertionsSignedXSBoolean(), (String)"XSBooleanValue was null");
        Assert.assertEquals((Object)descriptor.getWantAssertionsSignedXSBoolean(), (Object)new XSBooleanValue(Boolean.FALSE, false), (String)"XSBooleanValue was unexpected value");
        Assert.assertEquals((String)descriptor.getWantAssertionsSignedXSBoolean().toString(), (String)"false", (String)"XSBooleanValue string was unexpected value");
        descriptor.setWantAssertionsSigned((Boolean)null);
        Assert.assertEquals((Object)descriptor.getWantAssertionsSigned(), (Object)Boolean.FALSE, (String)"Unexpected default value for boolean attribute found");
        Assert.assertNull((Object)descriptor.getWantAssertionsSignedXSBoolean(), (String)"XSBooleanValue was not null");
    }

    private Signature buildSignatureSkeleton() {
        Signature signature = (Signature)this.buildXMLObject(Signature.DEFAULT_ELEMENT_NAME);
        signature.setSignatureAlgorithm("http://www.w3.org/2001/04/xmldsig-more#rsa-sha256");
        signature.setCanonicalizationAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        return signature;
    }
}

