/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.metadata.tests;

import java.io.InputStream;
import net.shibboleth.utilities.java.support.xml.XMLParserException;
import org.opensaml.core.testing.XMLObjectBaseTestCase;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.config.XMLObjectProviderRegistrySupport;
import org.opensaml.core.xml.io.Unmarshaller;
import org.opensaml.core.xml.io.UnmarshallingException;
import org.testng.Assert;
import org.testng.annotations.Test;
import org.w3c.dom.Document;

public class MetadataTest
extends XMLObjectBaseTestCase {
    @Test
    public void testInCommonUnmarshall() throws XMLParserException, UnmarshallingException {
        String inCommonMDFile = "/org/opensaml/saml/saml2/metadata/InCommon-metadata.xml";
        try {
            InputStream in = MetadataTest.class.getResourceAsStream(inCommonMDFile);
            Document inCommonMDDoc = parserPool.parse(in);
            Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(inCommonMDDoc.getDocumentElement());
            XMLObject inCommonMD = unmarshaller.unmarshall(inCommonMDDoc.getDocumentElement());
            Assert.assertEquals((String)inCommonMD.getElementQName().getLocalPart(), (String)"EntitiesDescriptor", (String)"First element of InCommon data was not expected EntitiesDescriptor");
        }
        catch (XMLParserException xe) {
            Assert.fail((String)("Unable to parse XML file: " + xe));
        }
        catch (UnmarshallingException ue) {
            Assert.fail((String)("Unable to unmarshall XML: " + ue));
        }
    }

    @Test
    public void testSWITCHUnmarshall() {
        String switchMDFile = "/org/opensaml/saml/saml2/metadata/metadata.switchaai_signed.xml";
        try {
            InputStream in = MetadataTest.class.getResourceAsStream(switchMDFile);
            Document switchMDDoc = parserPool.parse(in);
            Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(switchMDDoc.getDocumentElement());
            XMLObject switchMD = unmarshaller.unmarshall(switchMDDoc.getDocumentElement());
            Assert.assertEquals((String)switchMD.getElementQName().getLocalPart(), (String)"EntitiesDescriptor", (String)"First element of SWITCH data was not expected EntitiesDescriptor");
        }
        catch (XMLParserException xe) {
            Assert.fail((String)("Unable to parse XML file: " + xe));
        }
        catch (UnmarshallingException ue) {
            Assert.fail((String)("Unable to unmarshall XML: " + ue));
        }
    }

    @Test
    public void testUKFedUnmarshall() {
        String switchMDFile = "/org/opensaml/saml/saml2/metadata/ukfederation-metadata.xml";
        try {
            InputStream in = MetadataTest.class.getResourceAsStream(switchMDFile);
            Document ukFedDoc = parserPool.parse(in);
            Unmarshaller unmarshaller = XMLObjectProviderRegistrySupport.getUnmarshallerFactory().getUnmarshaller(ukFedDoc.getDocumentElement());
            XMLObject ukFedMD = unmarshaller.unmarshall(ukFedDoc.getDocumentElement());
            Assert.assertEquals((String)ukFedMD.getElementQName().getLocalPart(), (String)"EntitiesDescriptor", (String)"First element of UK Federation data was not expected EntitiesDescriptor");
        }
        catch (XMLParserException xe) {
            Assert.fail((String)("Unable to parse XML file: " + xe));
        }
        catch (UnmarshallingException ue) {
            Assert.fail((String)("Unable to unmarshall XML: " + ue));
        }
    }
}

