/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.saml.saml2.profile.impl;

import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.testing.OpenSAMLInitBaseTestCase;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.saml.saml2.core.Assertion;
import org.opensaml.saml.saml2.core.Response;
import org.opensaml.saml.saml2.core.Subject;
import org.opensaml.saml.saml2.profile.impl.CopyNameIDFromRequest;
import org.opensaml.saml.saml2.testing.SAML2ActionTestingSupport;
import org.testng.Assert;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class CopyNameIDFromRequestTest
extends OpenSAMLInitBaseTestCase {
    private static final String NAME_QUALIFIER = "https://idp.example.org";
    private ProfileRequestContext prc;
    private CopyNameIDFromRequest action;

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.action = new CopyNameIDFromRequest();
        this.action.initialize();
    }

    @Test
    public void testNoResponse() {
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoAssertions() {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildResponse());
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertTrue((boolean)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().isEmpty());
    }

    @Test
    public void testNoRequest() {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildResponse());
        ((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.addAssertions();
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    public void testNoName() {
        this.prc.getOutboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildResponse());
        ((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.addAssertions();
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAttributeQueryRequest(null));
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidMessageContext");
    }

    @Test
    void testCopy() {
        Subject subject = SAML2ActionTestingSupport.buildSubject((String)"jdoe");
        subject.getNameID().setNameQualifier(NAME_QUALIFIER);
        this.prc.getInboundMessageContext().setMessage((Object)SAML2ActionTestingSupport.buildAttributeQueryRequest((Subject)subject));
        this.addAssertions();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assertion assertion = (Assertion)((Response)this.prc.getOutboundMessageContext().getMessage()).getAssertions().get(0);
        subject = assertion.getSubject();
        Assert.assertNotNull((Object)subject);
        Assert.assertNotNull((Object)subject.getNameID());
        Assert.assertEquals((String)subject.getNameID().getValue(), (String)"jdoe");
        Assert.assertEquals((String)subject.getNameID().getNameQualifier(), (String)NAME_QUALIFIER);
    }

    private void addAssertions() {
        Response response = SAML2ActionTestingSupport.buildResponse();
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        response.getAssertions().add(SAML2ActionTestingSupport.buildAssertion());
        this.prc.getOutboundMessageContext().setMessage((Object)response);
    }
}

