/*
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

/**
 * 
 */

package org.opensaml.saml.ext.samlec.impl;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;

import org.opensaml.saml.common.AbstractSAMLObjectBuilder;
import org.opensaml.saml.common.xml.SAMLConstants;
import org.opensaml.saml.ext.samlec.SessionKey;


/**
 * A Builder for {@link SessionKey} objects.
 */
public class SessionKeyBuilder extends AbstractSAMLObjectBuilder<SessionKey> {

    /** {@inheritDoc} */
    @Override
    @Nonnull public SessionKey buildObject() {
        return buildObject(SAMLConstants.SAMLEC_GSS_NS, SessionKey.DEFAULT_ELEMENT_LOCAL_NAME,
                SAMLConstants.SAMLEC_GSS_PREFIX);
    }

    /** {@inheritDoc} */
    @Override
    @Nonnull public SessionKey buildObject(@Nullable final String namespaceURI, @Nonnull final String localName,
            @Nullable final String namespacePrefix) {
        return new SessionKeyImpl(namespaceURI, localName, namespacePrefix);
    }

}