/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security;

import java.security.Provider;
import java.security.Security;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class SecurityProviderTestSupport {
    public static final String BC_PROVIDER_NAME = "BC";
    public static final String SUNEC_PROVIDER_NAME = "SunEC";
    private boolean hadBCOriginally = Security.getProvider("BC") != null;

    public void loadBC() {
        if (!this.haveBC()) {
            Security.addProvider((Provider)new BouncyCastleProvider());
        }
    }

    public void unloadBC() {
        if (!this.hadBCOriginally && this.haveBC()) {
            Security.removeProvider(BC_PROVIDER_NAME);
        }
    }

    public boolean haveBC() {
        return Security.getProvider(BC_PROVIDER_NAME) != null;
    }

    public boolean haveSunEC() {
        return Security.getProvider(SUNEC_PROVIDER_NAME) != null;
    }

    public boolean haveJavaGreaterOrEqual(int requiredVersion) {
        return this.getJavaVersion() >= requiredVersion;
    }

    public int getJavaVersion() {
        String versionStr = System.getProperty("java.version");
        return Integer.parseInt(versionStr.split("\\.")[1]);
    }

    public boolean isOpenJDK() {
        return System.getProperty("java.runtime.name", "").startsWith("OpenJDK") || System.getProperty("java.vm.name", "").startsWith("OpenJDK");
    }
}

