/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient;

import com.google.common.collect.Lists;
import java.io.File;
import java.net.URISyntaxException;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import net.shibboleth.utilities.java.support.resolver.CriteriaSet;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.conn.ssl.StrictHostnameVerifier;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.opensaml.security.SecurityException;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.opensaml.security.httpclient.HttpClientSecuritySupport;
import org.opensaml.security.trust.TrustEngine;
import org.opensaml.security.x509.BasicX509Credential;
import org.opensaml.security.x509.X509Credential;
import org.opensaml.security.x509.X509Support;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.Test;

public class HttpClientSecuritySupportTest {
    private X509Certificate cert;
    private String certDERPath = "/data/certificate.der";

    @BeforeClass
    public void generatedTestData() throws NoSuchAlgorithmException, NoSuchProviderException, CertificateException, URISyntaxException {
        this.cert = X509Support.decodeCertificate((File)new File(HttpClientSecuritySupportTest.class.getResource(this.certDERPath).toURI()));
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testMarshalSecurityParametersNullContext() {
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        HttpClientSecuritySupport.marshalSecurityParameters(null, (HttpClientSecurityParameters)params, (boolean)false);
    }

    @Test
    public void testMarshalNullSecurityParameters() {
        HttpClientContext context = HttpClientContext.create();
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)context, null, (boolean)false);
        Assert.assertNull((Object)context.getCredentialsProvider());
        Assert.assertNull((Object)context.getAttribute("opensaml.TrustEngine"));
        Assert.assertNull((Object)context.getAttribute("opensaml.CriteriaSet"));
        Assert.assertNull((Object)context.getAttribute("javasupport.TLSProtocols"));
        Assert.assertNull((Object)context.getAttribute("javasupport.TLSCipherSuites"));
        Assert.assertNull((Object)context.getAttribute("opensaml.ClientTLSCredential"));
        Assert.assertNull((Object)context.getAttribute("javasupport.HostnameVerifier"));
    }

    @Test
    public void testMarshalSecurityParametersEmptyContext() {
        HttpClientContext context = HttpClientContext.create();
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        params.setTLSTrustEngine((TrustEngine)new MockTrustEngine());
        params.setTLSCriteriaSet(new CriteriaSet());
        params.setTLSProtocols((List)Lists.newArrayList((Object[])new String[]{"foo"}));
        params.setTLSCipherSuites((List)Lists.newArrayList((Object[])new String[]{"foo"}));
        params.setClientTLSCredential((X509Credential)new BasicX509Credential(this.cert));
        params.setHostnameVerifier((X509HostnameVerifier)new StrictHostnameVerifier());
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)context, (HttpClientSecurityParameters)params, (boolean)false);
        Assert.assertSame((Object)context.getCredentialsProvider(), (Object)params.getCredentialsProvider());
        Assert.assertSame((Object)context.getAttribute("opensaml.TrustEngine"), (Object)params.getTLSTrustEngine());
        Assert.assertSame((Object)context.getAttribute("opensaml.CriteriaSet"), (Object)params.getTLSCriteriaSet());
        Assert.assertSame((Object)context.getAttribute("javasupport.TLSProtocols"), (Object)params.getTLSProtocols());
        Assert.assertSame((Object)context.getAttribute("javasupport.TLSCipherSuites"), (Object)params.getTLSCipherSuites());
        Assert.assertSame((Object)context.getAttribute("opensaml.ClientTLSCredential"), (Object)params.getClientTLSCredential());
        Assert.assertSame((Object)context.getAttribute("javasupport.HostnameVerifier"), (Object)params.getHostnameVerifier());
    }

    @Test
    public void testMarshalSecurityParametersWithReplacement() {
        HttpClientContext context = HttpClientContext.create();
        context.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        context.setAttribute("opensaml.TrustEngine", (Object)new MockTrustEngine());
        context.setAttribute("opensaml.CriteriaSet", (Object)new CriteriaSet());
        context.setAttribute("javasupport.TLSProtocols", (Object)Lists.newArrayList((Object[])new String[]{"foo"}));
        context.setAttribute("javasupport.TLSCipherSuites", (Object)Lists.newArrayList((Object[])new String[]{"foo"}));
        context.setAttribute("opensaml.ClientTLSCredential", (Object)new BasicX509Credential(this.cert));
        context.setAttribute("javasupport.HostnameVerifier", (Object)new StrictHostnameVerifier());
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        params.setTLSTrustEngine((TrustEngine)new MockTrustEngine());
        params.setTLSCriteriaSet(new CriteriaSet());
        params.setTLSProtocols((List)Lists.newArrayList((Object[])new String[]{"foo"}));
        params.setTLSCipherSuites((List)Lists.newArrayList((Object[])new String[]{"foo"}));
        params.setClientTLSCredential((X509Credential)new BasicX509Credential(this.cert));
        params.setHostnameVerifier((X509HostnameVerifier)new StrictHostnameVerifier());
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)context, (HttpClientSecurityParameters)params, (boolean)true);
        Assert.assertSame((Object)context.getCredentialsProvider(), (Object)params.getCredentialsProvider());
        Assert.assertSame((Object)context.getAttribute("opensaml.TrustEngine"), (Object)params.getTLSTrustEngine());
        Assert.assertSame((Object)context.getAttribute("opensaml.CriteriaSet"), (Object)params.getTLSCriteriaSet());
        Assert.assertSame((Object)context.getAttribute("javasupport.TLSProtocols"), (Object)params.getTLSProtocols());
        Assert.assertSame((Object)context.getAttribute("javasupport.TLSCipherSuites"), (Object)params.getTLSCipherSuites());
        Assert.assertSame((Object)context.getAttribute("opensaml.ClientTLSCredential"), (Object)params.getClientTLSCredential());
        Assert.assertSame((Object)context.getAttribute("javasupport.HostnameVerifier"), (Object)params.getHostnameVerifier());
    }

    @Test
    public void testMarshalSecurityParametersWithoutReplacement() {
        HttpClientContext context = HttpClientContext.create();
        BasicCredentialsProvider credProvider = new BasicCredentialsProvider();
        MockTrustEngine trustEngine = new MockTrustEngine();
        CriteriaSet criteriaSet = new CriteriaSet();
        ArrayList protocols = Lists.newArrayList((Object[])new String[]{"foo"});
        ArrayList cipherSuites = Lists.newArrayList((Object[])new String[]{"foo"});
        BasicX509Credential clientTLSCred = new BasicX509Credential(this.cert);
        StrictHostnameVerifier verifier = new StrictHostnameVerifier();
        context.setCredentialsProvider((CredentialsProvider)credProvider);
        context.setAttribute("opensaml.TrustEngine", (Object)trustEngine);
        context.setAttribute("opensaml.CriteriaSet", (Object)criteriaSet);
        context.setAttribute("javasupport.TLSProtocols", (Object)protocols);
        context.setAttribute("javasupport.TLSCipherSuites", (Object)cipherSuites);
        context.setAttribute("opensaml.ClientTLSCredential", (Object)clientTLSCred);
        context.setAttribute("javasupport.HostnameVerifier", (Object)verifier);
        HttpClientSecurityParameters params = new HttpClientSecurityParameters();
        params.setCredentialsProvider((CredentialsProvider)new BasicCredentialsProvider());
        params.setTLSTrustEngine((TrustEngine)new MockTrustEngine());
        params.setTLSCriteriaSet(new CriteriaSet());
        params.setTLSProtocols((List)Lists.newArrayList((Object[])new String[]{"foo"}));
        params.setTLSCipherSuites((List)Lists.newArrayList((Object[])new String[]{"foo"}));
        params.setClientTLSCredential((X509Credential)new BasicX509Credential(this.cert));
        params.setHostnameVerifier((X509HostnameVerifier)new StrictHostnameVerifier());
        HttpClientSecuritySupport.marshalSecurityParameters((HttpClientContext)context, (HttpClientSecurityParameters)params, (boolean)false);
        Assert.assertSame((Object)context.getCredentialsProvider(), (Object)credProvider);
        Assert.assertSame((Object)context.getAttribute("opensaml.TrustEngine"), (Object)trustEngine);
        Assert.assertSame((Object)context.getAttribute("opensaml.CriteriaSet"), (Object)criteriaSet);
        Assert.assertSame((Object)context.getAttribute("javasupport.TLSProtocols"), (Object)protocols);
        Assert.assertSame((Object)context.getAttribute("javasupport.TLSCipherSuites"), (Object)cipherSuites);
        Assert.assertSame((Object)context.getAttribute("opensaml.ClientTLSCredential"), (Object)clientTLSCred);
        Assert.assertSame((Object)context.getAttribute("javasupport.HostnameVerifier"), (Object)verifier);
    }

    @Test
    public void testSetContextValue() {
        String attribName = "MyAttrib";
        HttpClientContext context = null;
        context = HttpClientContext.create();
        HttpClientSecuritySupport.setContextValue((HttpClientContext)context, (String)attribName, (Object)"foo", (boolean)false);
        Assert.assertEquals((Object)context.getAttribute(attribName), (Object)"foo");
        context = HttpClientContext.create();
        HttpClientSecuritySupport.setContextValue((HttpClientContext)context, (String)attribName, null, (boolean)false);
        Assert.assertNull((Object)context.getAttribute(attribName));
        context = HttpClientContext.create();
        context.setAttribute(attribName, (Object)"bar");
        HttpClientSecuritySupport.setContextValue((HttpClientContext)context, (String)attribName, (Object)"foo", (boolean)false);
        Assert.assertEquals((Object)context.getAttribute(attribName), (Object)"bar");
        context = HttpClientContext.create();
        context.setAttribute(attribName, (Object)"bar");
        HttpClientSecuritySupport.setContextValue((HttpClientContext)context, (String)attribName, (Object)"foo", (boolean)true);
        Assert.assertEquals((Object)context.getAttribute(attribName), (Object)"foo");
        context = HttpClientContext.create();
        context.setAttribute(attribName, (Object)"bar");
        HttpClientSecuritySupport.setContextValue((HttpClientContext)context, (String)attribName, null, (boolean)true);
        Assert.assertEquals((Object)context.getAttribute(attribName), (Object)"bar");
        try {
            HttpClientSecuritySupport.setContextValue(null, (String)attribName, (Object)"foo", (boolean)false);
            Assert.fail((String)"Null context value");
        }
        catch (ConstraintViolationException e) {
            // empty catch block
        }
        try {
            context = HttpClientContext.create();
            HttpClientSecuritySupport.setContextValue((HttpClientContext)context, null, (Object)"foo", (boolean)false);
            Assert.fail((String)"Null attribute name");
        }
        catch (ConstraintViolationException constraintViolationException) {
            // empty catch block
        }
    }

    public static class MockTrustEngine
    implements TrustEngine<X509Credential> {
        public boolean validate(X509Credential token, CriteriaSet trustBasisCriteria) throws SecurityException {
            return false;
        }
    }
}

