/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.crypto;

import java.io.InputStream;
import java.security.InvalidParameterException;
import java.security.Key;
import java.security.KeyException;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.PrivateKey;
import java.security.PublicKey;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import org.opensaml.security.SecurityException;
import org.opensaml.security.crypto.KeySupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testng.Assert;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

public class KeySupportTest {
    private final Logger log = LoggerFactory.getLogger(KeySupportTest.class);
    private String rsaPrivKeyPEMNoEncrypt = "/data/rsa-privkey-nopass.pem";
    private String rsaPrivKeyDERNoEncrypt = "/data/rsa-privkey-nopass.der";
    private String dsaPrivKeyPEMNoEncrypt = "/data/dsa-privkey-nopass.pem";
    private String dsaPrivKeyDERNoEncrypt = "/data/dsa-privkey-nopass.der";
    private char[] privKeyPassword = new char[]{'c', 'h', 'a', 'n', 'g', 'e', 'i', 't'};
    private String rsaPrivKeyPEMEncrypt = "/data/rsa-privkey-changeit-pass.pem";
    private String dsaPrivKeyPEMEncrypt = "/data/dsa-privkey-changeit-pass.pem";
    private String ecPrivKeyPEMNoEncrypt = "/data/ec-privkey-nopass.pem";

    @Test
    public void testDecodeRSAPrivateKeyPEMNoEncrypt() throws Exception {
        this.testPrivKey(this.rsaPrivKeyPEMNoEncrypt, null, "RSA");
    }

    @Test
    public void testDecodeRSAPrivateKeyPEMEncrypt() throws Exception {
        this.testPrivKey(this.rsaPrivKeyPEMEncrypt, this.privKeyPassword, "RSA");
    }

    @Test
    public void testDecodeRSAPrivateKeyDERNoEncrypt() throws Exception {
        this.testPrivKey(this.rsaPrivKeyDERNoEncrypt, null, "RSA");
    }

    @Test
    public void testDecodeDSAPrivateKeyPEMNoEncrypt() throws Exception {
        this.testPrivKey(this.dsaPrivKeyPEMNoEncrypt, null, "DSA");
    }

    @Test
    public void testDecodeDSAPrivateKeyPEMEncrypt() throws Exception {
        this.testPrivKey(this.dsaPrivKeyPEMEncrypt, this.privKeyPassword, "DSA");
    }

    @Test
    public void testDecodeDSAPrivateKeyDERNoEncrypt() throws Exception {
        this.testPrivKey(this.dsaPrivKeyDERNoEncrypt, null, "DSA");
    }

    @Test
    public void testDecodeECPrivateKeyPEMNoEncrypt() throws Exception {
        this.testPrivKey(this.ecPrivKeyPEMNoEncrypt, null, "EC");
    }

    @Test
    public void testDerivePublicKey() throws Exception {
        PrivateKey privKey = this.testPrivKey(this.rsaPrivKeyPEMNoEncrypt, null, "RSA");
        PublicKey pubKey = KeySupport.derivePublicKey((PrivateKey)privKey);
        Assert.assertNotNull((Object)pubKey);
        Assert.assertEquals((String)pubKey.getAlgorithm(), (String)"RSA");
        Assert.assertTrue((boolean)KeySupport.matchKeyPair((PublicKey)pubKey, (PrivateKey)privKey));
        pubKey = null;
        privKey = this.testPrivKey(this.dsaPrivKeyPEMNoEncrypt, null, "DSA");
        pubKey = KeySupport.derivePublicKey((PrivateKey)privKey);
        Assert.assertNotNull((Object)pubKey);
        Assert.assertEquals((String)pubKey.getAlgorithm(), (String)"DSA");
        Assert.assertTrue((boolean)KeySupport.matchKeyPair((PublicKey)pubKey, (PrivateKey)privKey));
    }

    @Test
    public void testKeyPairMatching() throws NoSuchAlgorithmException, NoSuchProviderException, SecurityException {
        KeyPair kp1rsa = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        KeyPair kp2rsa = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        KeyPair kp1dsa = KeySupport.generateKeyPair((String)"DSA", (int)1024, null);
        KeyPair kp2dsa = KeySupport.generateKeyPair((String)"DSA", (int)1024, null);
        Assert.assertTrue((boolean)KeySupport.matchKeyPair((PublicKey)kp1rsa.getPublic(), (PrivateKey)kp1rsa.getPrivate()));
        Assert.assertTrue((boolean)KeySupport.matchKeyPair((PublicKey)kp2rsa.getPublic(), (PrivateKey)kp2rsa.getPrivate()));
        Assert.assertFalse((boolean)KeySupport.matchKeyPair((PublicKey)kp1rsa.getPublic(), (PrivateKey)kp2rsa.getPrivate()));
        Assert.assertFalse((boolean)KeySupport.matchKeyPair((PublicKey)kp2rsa.getPublic(), (PrivateKey)kp1rsa.getPrivate()));
        Assert.assertTrue((boolean)KeySupport.matchKeyPair((PublicKey)kp1dsa.getPublic(), (PrivateKey)kp1dsa.getPrivate()));
        Assert.assertTrue((boolean)KeySupport.matchKeyPair((PublicKey)kp2dsa.getPublic(), (PrivateKey)kp2dsa.getPrivate()));
        Assert.assertFalse((boolean)KeySupport.matchKeyPair((PublicKey)kp1dsa.getPublic(), (PrivateKey)kp2dsa.getPrivate()));
        Assert.assertFalse((boolean)KeySupport.matchKeyPair((PublicKey)kp2dsa.getPublic(), (PrivateKey)kp1dsa.getPrivate()));
        try {
            Assert.assertFalse((boolean)KeySupport.matchKeyPair((PublicKey)kp1rsa.getPublic(), (PrivateKey)kp2dsa.getPrivate()));
            Assert.fail((String)"Key algorithm mismatch should have caused evaluation failure");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)KeySupport.matchKeyPair((PublicKey)kp1rsa.getPublic(), null));
            Assert.fail((String)"Null key should have caused failure");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            Assert.assertFalse((boolean)KeySupport.matchKeyPair(null, (PrivateKey)kp1rsa.getPrivate()));
            Assert.fail((String)"Key algorithm mismatch should have caused evaluation failure");
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }

    @Test
    public void testKeyLength() throws NoSuchAlgorithmException, NoSuchProviderException {
        KeyPair kp = null;
        kp = KeySupport.generateKeyPair((String)"RSA", (int)1024, null);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPublic()), (Object)1024);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPrivate()), (Object)1024);
        kp = KeySupport.generateKeyPair((String)"RSA", (int)2048, null);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPublic()), (Object)2048);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPrivate()), (Object)2048);
        kp = KeySupport.generateKeyPair((String)"RSA", (int)4096, null);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPublic()), (Object)4096);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPrivate()), (Object)4096);
        kp = KeySupport.generateKeyPair((String)"DSA", (int)512, null);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPublic()), (Object)512);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPrivate()), (Object)512);
        kp = KeySupport.generateKeyPair((String)"DSA", (int)1024, null);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPublic()), (Object)1024);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPrivate()), (Object)1024);
        try {
            kp = KeySupport.generateKeyPair((String)"EC", (int)112, null);
            Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPublic()), (Object)112);
            Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPrivate()), (Object)112);
        }
        catch (InvalidParameterException | NoSuchAlgorithmException e) {
            this.log.warn("EC-112 failed", (Throwable)e);
        }
        try {
            kp = KeySupport.generateKeyPair((String)"EC", (int)256, null);
            Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPublic()), (Object)256);
            Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPrivate()), (Object)256);
        }
        catch (InvalidParameterException | NoSuchAlgorithmException e) {
            this.log.warn("EC-256 failed", (Throwable)e);
        }
        try {
            kp = KeySupport.generateKeyPair((String)"EC", (int)571, null);
            Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPublic()), (Object)571);
            Assert.assertEquals((Object)KeySupport.getKeyLength((Key)kp.getPrivate()), (Object)571);
        }
        catch (InvalidParameterException | NoSuchAlgorithmException e) {
            this.log.warn("EC-571 failed", (Throwable)e);
        }
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)KeySupport.generateKey((String)"AES", (int)128, null)), (Object)128);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)KeySupport.generateKey((String)"AES", (int)192, null)), (Object)192);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)KeySupport.generateKey((String)"AES", (int)256, null)), (Object)256);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)KeySupport.generateKey((String)"DES", (int)56, null)), (Object)64);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)KeySupport.generateKey((String)"DESede", (int)112, null)), (Object)192);
        Assert.assertEquals((Object)KeySupport.getKeyLength((Key)KeySupport.generateKey((String)"DESede", (int)168, null)), (Object)192);
    }

    @DataProvider
    public Object[][] decodeSecretKeyData() {
        return new Object[][]{{128, "AES"}, {192, "AES"}, {256, "AES"}, {64, "DES"}, {168, "DESede"}, {192, "DESede"}};
    }

    @Test(dataProvider="decodeSecretKeyData")
    public void testDecodeSecretKey(Integer keyLengthBits, String algorithm) throws NoSuchAlgorithmException, KeyException {
        byte[] key = new byte[keyLengthBits / 8];
        SecureRandom.getInstance("SHA1PRNG").nextBytes(key);
        SecretKey secretKey = KeySupport.decodeSecretKey((byte[])key, (String)algorithm);
        Assert.assertNotNull((Object)secretKey);
        Assert.assertEquals((String)secretKey.getAlgorithm(), (String)algorithm);
        Assert.assertEquals((byte[])secretKey.getEncoded(), (byte[])key);
    }

    protected PrivateKey testPrivKey(String keyFile, char[] password, String algo) throws Exception {
        InputStream keyInS = KeySupportTest.class.getResourceAsStream(keyFile);
        byte[] keyBytes = new byte[keyInS.available()];
        keyInS.read(keyBytes);
        PrivateKey key = KeySupport.decodePrivateKey((byte[])keyBytes, (char[])password);
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((String)key.getAlgorithm(), (String)algo);
        key = KeySupport.decodePrivateKey((InputStream)KeySupportTest.class.getResourceAsStream(keyFile), (char[])password);
        Assert.assertNotNull((Object)key);
        Assert.assertEquals((String)key.getAlgorithm(), (String)algo);
        return key;
    }
}

