/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.security.httpclient;

import java.io.IOException;
import java.security.cert.X509Certificate;
import java.util.Collections;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import net.shibboleth.ext.spring.resource.HTTPResource;
import net.shibboleth.ext.spring.resource.ResourceTestHelper;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.httpclient.HttpClientBuilder;
import net.shibboleth.utilities.java.support.httpclient.HttpClientContextHandler;
import net.shibboleth.utilities.java.support.repository.RepositorySupport;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.ssl.X509HostnameVerifier;
import org.opensaml.security.httpclient.HttpClientSecurityContextHandler;
import org.opensaml.security.httpclient.HttpClientSecurityParameters;
import org.springframework.core.io.ClassPathResource;
import org.springframework.core.io.Resource;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class SecurityEnhancedHTTPResourceTest {
    private final String path = "net/shibboleth/ext/spring/resource/document.xml";
    private final String pathPrefix = "src/test/resources/";
    private final String existsHttps = RepositorySupport.buildHTTPSResourceURL((String)"spring-extensions", (String)"src/test/resources/net/shibboleth/ext/spring/resource/document.xml");
    private final String existsHttp = RepositorySupport.buildHTTPResourceURL((String)"spring-extensions", (String)"src/test/resources/net/shibboleth/ext/spring/resource/document.xml", (boolean)false);
    private HttpClient client;
    private HttpClientSecurityParameters params;
    private HttpClientSecurityContextHandler handler;

    @BeforeClass
    public void setupClient() throws Exception {
        this.client = new HttpClientBuilder().buildClient();
    }

    @BeforeMethod
    public void setUp() throws ComponentInitializationException {
        this.params = new HttpClientSecurityParameters();
        this.handler = new HttpClientSecurityContextHandler();
        this.handler.setHttpClientSecurityParameters(this.params);
        this.handler.initialize();
    }

    @Test
    public void testNoSecurityAdded() throws IOException, ComponentInitializationException {
        HTTPResource existsResource = new HTTPResource(this.client, this.existsHttp);
        existsResource.setHttpClientContextHandler((HttpClientContextHandler)this.handler);
        Assert.assertTrue((boolean)ResourceTestHelper.compare((Resource)existsResource, (Resource)new ClassPathResource("net/shibboleth/ext/spring/resource/document.xml")));
    }

    @Test
    public void testHostnameRejected() throws IOException, ComponentInitializationException {
        HTTPResource existsResource = new HTTPResource(this.client, this.existsHttps);
        existsResource.setHttpClientContextHandler((HttpClientContextHandler)this.handler);
        this.params.setHostnameVerifier(new X509HostnameVerifier(){

            public boolean verify(String arg0, SSLSession arg1) {
                return false;
            }

            public void verify(String host, SSLSocket ssl) throws IOException {
                throw new IOException("Rejecting hostname for test");
            }

            public void verify(String host, X509Certificate cert) throws SSLException {
                throw new SSLException("Rejecting hostname for test");
            }

            public void verify(String host, String[] cns, String[] subjectAlts) throws SSLException {
                throw new SSLException("Rejecting hostname for test");
            }
        });
        Assert.assertFalse((boolean)existsResource.exists());
    }

    @Test
    public void testBadSSLProtocol() throws IOException, ComponentInitializationException {
        HTTPResource existsResource = new HTTPResource(this.client, this.existsHttps);
        existsResource.setHttpClientContextHandler((HttpClientContextHandler)this.handler);
        this.params.setTLSProtocols(Collections.singletonList("SSLv3"));
        Assert.assertFalse((boolean)existsResource.exists());
    }
}

