/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.soap.soap11.decoder.http.impl;

import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import org.opensaml.core.xml.XMLObject;
import org.opensaml.messaging.context.MessageContext;
import org.opensaml.messaging.decoder.MessageDecodingException;
import org.opensaml.messaging.decoder.servlet.BaseHttpServletRequestXMLMessageDecoder;
import org.opensaml.messaging.handler.MessageHandler;
import org.opensaml.messaging.handler.MessageHandlerException;
import org.opensaml.soap.messaging.context.SOAP11Context;
import org.opensaml.soap.soap11.Envelope;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HTTPSOAP11Decoder<MessageType extends XMLObject>
extends BaseHttpServletRequestXMLMessageDecoder<MessageType> {
    private final Logger log = LoggerFactory.getLogger(HTTPSOAP11Decoder.class);
    private MessageHandler<MessageType> bodyHandler;

    public MessageHandler<MessageType> getBodyHandler() {
        return this.bodyHandler;
    }

    public void setBodyHandler(MessageHandler<MessageType> newBodyHandler) {
        this.bodyHandler = newBodyHandler;
    }

    protected void doDecode() throws MessageDecodingException {
        MessageContext messageContext = new MessageContext();
        HttpServletRequest request = this.getHttpServletRequest();
        if (!"POST".equalsIgnoreCase(request.getMethod())) {
            throw new MessageDecodingException("This message decoder only supports the HTTP POST method");
        }
        this.log.debug("Unmarshalling SOAP message");
        try {
            Envelope soapMessage = (Envelope)this.unmarshallMessage((InputStream)request.getInputStream());
            ((SOAP11Context)messageContext.getSubcontext(SOAP11Context.class, true)).setEnvelope(soapMessage);
        }
        catch (IOException e) {
            this.log.error("Unable to obtain input stream from HttpServletRequest", (Throwable)e);
            throw new MessageDecodingException("Unable to obtain input stream from HttpServletRequest", (Exception)e);
        }
        try {
            this.getBodyHandler().invoke(messageContext);
        }
        catch (MessageHandlerException e) {
            this.log.error("Error processing SOAP Envelope body", (Throwable)e);
            throw new MessageDecodingException("Error processing SOAP Envelope body", (Exception)((Object)e));
        }
        if (messageContext.getMessage() == null) {
            this.log.warn("Body handler did not properly populate the message in message context");
            throw new MessageDecodingException("Body handler did not properly populate the message in message context");
        }
        this.setMessageContext(messageContext);
    }

    protected void doInitialize() throws ComponentInitializationException {
        super.doInitialize();
        if (this.getBodyHandler() == null) {
            throw new ComponentInitializationException("Body handler MessageHandler cannot be null");
        }
    }

    protected XMLObject getMessageToLog() {
        return ((SOAP11Context)this.getMessageContext().getSubcontext(SOAP11Context.class, true)).getEnvelope();
    }
}

