/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.client;

import com.google.common.net.UrlEscapers;
import java.io.IOException;
import java.util.Collections;
import java.util.concurrent.locks.Lock;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.net.HttpServletRequestResponseContext;
import net.shibboleth.utilities.java.support.net.ThreadLocalHttpServletRequestSupplier;
import net.shibboleth.utilities.java.support.primitive.NonnullSupplier;
import org.opensaml.messaging.context.BaseContext;
import org.opensaml.profile.context.ProfileRequestContext;
import org.opensaml.profile.testing.ActionTestingSupport;
import org.opensaml.profile.testing.RequestContextBuilder;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.client.AbstractBaseClientStorageServiceTest;
import org.opensaml.storage.impl.client.ClientStorageLoadContext;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.opensaml.storage.impl.client.ClientStorageServiceOperation;
import org.opensaml.storage.impl.client.LoadClientStorageServices;
import org.springframework.mock.web.MockHttpServletRequest;
import org.springframework.mock.web.MockHttpServletResponse;
import org.testng.Assert;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class LoadClientStorageServicesTest
extends AbstractBaseClientStorageServiceTest {
    private ProfileRequestContext prc;
    private ClientStorageLoadContext loadCtx;
    private LoadClientStorageServices action;

    @BeforeClass
    public void setUpClass() throws ComponentInitializationException {
        this.init();
    }

    @BeforeMethod
    public void setUp() {
        this.prc = new RequestContextBuilder().buildProfileRequestContext();
        this.loadCtx = (ClientStorageLoadContext)this.prc.getSubcontext(ClientStorageLoadContext.class, true);
        this.loadCtx.getStorageKeys().add("foo");
        this.action = new LoadClientStorageServices();
        this.action.setHttpServletRequestSupplier((NonnullSupplier)new ThreadLocalHttpServletRequestSupplier());
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
    }

    @Test
    public void testNoContext() throws ComponentInitializationException {
        this.action.setStorageServices(Collections.singletonList(this.getStorageService()));
        this.action.initialize();
        this.prc.removeSubcontext((BaseContext)this.loadCtx);
        this.action.execute(this.prc);
        ActionTestingSupport.assertEvent((ProfileRequestContext)this.prc, (Object)"InvalidProfileContext");
    }

    @Test
    public void testNoKeys() throws ComponentInitializationException {
        this.action.initialize();
        this.loadCtx.getStorageKeys().clear();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
    }

    @Test
    public void testNoServices() throws ComponentInitializationException {
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testEmpty() throws ComponentInitializationException, IOException {
        ClientStorageService ss = this.getStorageService();
        Lock lock = ss.getLock().readLock();
        try {
            lock.lock();
            ss.getContextMap();
            Assert.fail((String)"getContextMap should have failed for unloaded storage service");
        }
        catch (IOException iOException) {
        }
        finally {
            lock.unlock();
        }
        this.action.setStorageServices(Collections.singletonList(ss));
        this.action.initialize();
        Cookie cookie = new Cookie("bar", "ignored");
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNull((Object)this.loadCtx.getParent());
        try {
            lock.lock();
            Assert.assertTrue((boolean)ss.getContextMap().isEmpty());
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInvalid() throws ComponentInitializationException, IOException {
        ClientStorageService ss = this.getStorageService();
        this.action.setStorageServices(Collections.singletonList(ss));
        this.action.initialize();
        Cookie cookie = new Cookie("foo", "error");
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        Assert.assertNull((Object)this.loadCtx.getParent());
        Lock lock = ss.getLock().readLock();
        try {
            lock.lock();
            Assert.assertTrue((boolean)ss.getContextMap().isEmpty());
        }
        finally {
            lock.unlock();
        }
    }

    @Test
    public void testCookieLoad() throws ComponentInitializationException, IOException {
        ClientStorageService ss = this.getStorageService();
        ss.load(null, ClientStorageService.ClientStorageSource.COOKIE);
        ss.create("context1", "key1", "value1", null);
        ss.create("context1", "key2", "value2", null);
        ss.create("context2", "key", "value", null);
        ClientStorageServiceOperation saved = ss.save();
        Assert.assertNotNull((Object)saved);
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertFalse((boolean)ss.isLoaded());
        Cookie cookie = new Cookie("foo", UrlEscapers.urlFormParameterEscaper().escape(saved.getValue()));
        ((MockHttpServletRequest)HttpServletRequestResponseContext.getRequest()).setCookies(new Cookie[]{cookie});
        this.action.setUseLocalStorage(true);
        this.action.setStorageServices(Collections.singletonList(ss));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        this.checkStorageContent((StorageService)ss);
    }

    @Test
    public void testFormLoad() throws ComponentInitializationException, IOException {
        ClientStorageService ss = this.getStorageService();
        ss.load(null, ClientStorageService.ClientStorageSource.COOKIE);
        ss.create("context1", "key1", "value1", null);
        ss.create("context1", "key2", "value2", null);
        ss.create("context2", "key", "value", null);
        ClientStorageServiceOperation saved = ss.save();
        Assert.assertNotNull((Object)saved);
        HttpServletRequestResponseContext.loadCurrent((HttpServletRequest)new MockHttpServletRequest(), (HttpServletResponse)new MockHttpServletResponse());
        Assert.assertFalse((boolean)ss.isLoaded());
        MockHttpServletRequest request = (MockHttpServletRequest)HttpServletRequestResponseContext.getRequest();
        request.setParameter("shib_idp_ls_supported", "true");
        request.setParameter("shib_idp_ls_success." + ss.getStorageName(), "true");
        request.setParameter("shib_idp_ls_value." + ss.getStorageName(), saved.getValue());
        this.action.setUseLocalStorage(true);
        this.action.setStorageServices(Collections.singletonList(ss));
        this.action.initialize();
        this.action.execute(this.prc);
        ActionTestingSupport.assertProceedEvent((ProfileRequestContext)this.prc);
        this.checkStorageContent((StorageService)ss);
    }

    private void checkStorageContent(StorageService ss) throws IOException {
        Assert.assertNull((Object)this.loadCtx.getParent());
        StorageRecord record = ss.read("context1", "key1");
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((String)record.getValue(), (String)"value1");
        Assert.assertNull((Object)record.getExpiration());
        record = ss.read("context1", "key2");
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((String)record.getValue(), (String)"value2");
        Assert.assertNull((Object)record.getExpiration());
        record = ss.read("context2", "key");
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((String)record.getValue(), (String)"value");
        Assert.assertNull((Object)record.getExpiration());
    }
}

