/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import java.time.Instant;
import org.opensaml.storage.ReplayCache;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class ReplayCacheTest {
    private String context;
    private String messageID;
    private Instant expiration;
    private MemoryStorageService storageService;
    private ReplayCache replayCache;

    @BeforeMethod
    protected void setUp() throws Exception {
        this.context = this.getClass().getName();
        this.messageID = "abc123";
        this.expiration = Instant.now().plusSeconds(180L);
        this.storageService = new MemoryStorageService();
        this.storageService.setId("test");
        this.storageService.initialize();
        this.replayCache = new ReplayCache();
        this.replayCache.setStorage((StorageService)this.storageService);
        this.replayCache.initialize();
    }

    @AfterMethod
    protected void tearDown() {
        this.replayCache.destroy();
        this.replayCache = null;
        this.storageService.destroy();
        this.storageService = null;
    }

    @Test
    public void testInit() {
        this.replayCache = new ReplayCache();
        try {
            this.replayCache.setStorage(null);
            Assert.fail((String)"Null StorageService should have caused constraint violation");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.replayCache.setStorage((StorageService)new ClientStorageService());
            Assert.fail((String)"ClientStorageService should have caused constraint violation");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testNonReplayEmptyCache() {
        Assert.assertTrue((boolean)this.replayCache.check(this.context, this.messageID, this.expiration), (String)"Message was not replay, insert into empty cache");
    }

    @Test
    public void testNonReplayDistinctIDs() {
        Assert.assertTrue((boolean)this.replayCache.check(this.context, this.messageID, this.expiration), (String)"Message was not replay, insert into empty cache");
        Assert.assertTrue((boolean)this.replayCache.check(this.context, "IDWhichIsNot" + this.messageID, this.expiration), (String)"Message was not replay, insert into empty cache");
    }

    @Test
    public void testReplay() {
        Assert.assertTrue((boolean)this.replayCache.check(this.context, this.messageID, this.expiration), (String)"Message was not replay, insert into empty cache");
        Assert.assertFalse((boolean)this.replayCache.check(this.context, this.messageID, this.expiration), (String)"Message was replay");
    }

    @Test
    public void testNonReplayValidByMillisecondExpiriation() throws InterruptedException {
        Assert.assertTrue((boolean)this.replayCache.check(this.context, this.messageID, Instant.now().plusSeconds(1L)), (String)"Message was not replay, insert into empty cache");
        Thread.sleep(2000L);
        Assert.assertTrue((boolean)this.replayCache.check(this.context, this.messageID, Instant.now().plusSeconds(1L)), (String)"Message was not replay, previous cache entry should have expired");
    }
}

