/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl;

import java.io.IOException;
import java.nio.charset.Charset;
import java.time.Duration;
import java.util.Random;
import net.shibboleth.utilities.java.support.component.ComponentInitializationException;
import net.shibboleth.utilities.java.support.logic.ConstraintViolationException;
import org.opensaml.storage.RevocationCache;
import org.opensaml.storage.StorageService;
import org.opensaml.storage.impl.MemoryStorageService;
import org.opensaml.storage.impl.client.ClientStorageService;
import org.testng.Assert;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;
import org.testng.annotations.Test;

public class RevocationCacheTest {
    private MemoryStorageService storageService;
    private RevocationCache revocationCache;

    @BeforeMethod
    protected void setUp() throws ComponentInitializationException {
        this.storageService = new MemoryStorageService();
        this.storageService.setId("test");
        this.storageService.setCleanupInterval(Duration.ZERO);
        this.storageService.initialize();
        this.revocationCache = new RevocationCache();
        this.revocationCache.setId("test");
        this.revocationCache.setEntryExpiration(Duration.ofMillis(500L));
        this.revocationCache.setStorage((StorageService)this.storageService);
        this.revocationCache.initialize();
    }

    @AfterMethod
    protected void tearDown() {
        this.revocationCache.destroy();
        this.storageService.destroy();
    }

    @Test
    public void testInit() {
        this.revocationCache = new RevocationCache();
        try {
            this.revocationCache.setStorage(null);
            Assert.fail((String)"Null StorageService should have caused constraint violation");
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            this.revocationCache.setStorage((StorageService)new ClientStorageService());
            Assert.fail((String)"ClientStorageService should have caused constraint violation");
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    @Test
    public void testStrictSetter() throws ComponentInitializationException {
        Assert.assertFalse((boolean)this.revocationCache.isStrict());
        this.revocationCache = new RevocationCache();
        this.revocationCache.setId("test");
        this.revocationCache.setStorage((StorageService)this.storageService);
        this.revocationCache.setStrict(true);
        this.revocationCache.initialize();
        Assert.assertTrue((boolean)this.revocationCache.isStrict());
    }

    @Test(expectedExceptions={ConstraintViolationException.class})
    public void testExpirationSetter() {
        this.revocationCache = new RevocationCache();
        this.revocationCache.setEntryExpiration(Duration.ZERO);
    }

    @Test
    public void testStorageGetter() {
        Assert.assertEquals((Object)this.storageService, (Object)this.revocationCache.getStorage());
    }

    @Test
    public void testRevocationSuccess() {
        Assert.assertFalse((boolean)this.revocationCache.isRevoked("context", "item"));
        Assert.assertTrue((boolean)this.revocationCache.revoke("context", "item"));
        Assert.assertTrue((boolean)this.revocationCache.isRevoked("context", "item"));
    }

    @Test
    public void testRevocationSuccessLongContext() throws ComponentInitializationException {
        this.storageService = new MemoryStorageService();
        this.storageService.setId("test");
        this.storageService.setContextSize(50);
        this.storageService.setCleanupInterval(Duration.ZERO);
        this.storageService.initialize();
        this.revocationCache = new RevocationCache();
        this.revocationCache.setId("test");
        this.revocationCache.setStorage((StorageService)this.storageService);
        this.revocationCache.initialize();
        byte[] array = new byte[this.storageService.getCapabilities().getContextSize() * 2];
        new Random().nextBytes(array);
        String context = new String(array, Charset.forName("UTF-8"));
        Assert.assertTrue((context.length() > this.storageService.getCapabilities().getContextSize() ? 1 : 0) != 0);
        Assert.assertTrue((boolean)this.revocationCache.isRevoked(context, "item"));
        Assert.assertFalse((boolean)this.revocationCache.revoke(context, "item"));
    }

    @Test
    public void testRevocationSuccessLongLongItem() throws ComponentInitializationException {
        this.storageService = new MemoryStorageService();
        this.storageService.setId("test");
        this.storageService.setCleanupInterval(Duration.ZERO);
        this.storageService.setKeySize(50);
        this.storageService.initialize();
        this.revocationCache = new RevocationCache();
        this.revocationCache.setId("test");
        this.revocationCache.setStorage((StorageService)this.storageService);
        this.revocationCache.initialize();
        byte[] array = new byte[this.storageService.getCapabilities().getKeySize() * 2];
        new Random().nextBytes(array);
        String item = new String(array, Charset.forName("UTF-8"));
        Assert.assertTrue((item.length() > this.storageService.getCapabilities().getKeySize() ? 1 : 0) != 0);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked("context", item));
        Assert.assertTrue((boolean)this.revocationCache.revoke("context", item));
        Assert.assertTrue((boolean)this.revocationCache.isRevoked("context", item));
    }

    @Test
    public void testRevocationExpirationSuccess() throws InterruptedException {
        Assert.assertFalse((boolean)this.revocationCache.isRevoked("context", "item"));
        Assert.assertTrue((boolean)this.revocationCache.revoke("context", "item"));
        Thread.sleep(600L);
        Assert.assertFalse((boolean)this.revocationCache.isRevoked("context", "item"));
        Assert.assertTrue((boolean)this.revocationCache.revoke("context", "item"));
        Thread.sleep(300L);
        Assert.assertTrue((boolean)this.revocationCache.revoke("context", "item"));
        Thread.sleep(300L);
        Assert.assertTrue((boolean)this.revocationCache.isRevoked("context", "item"));
    }

    @Test
    public void testRevokedRecordFetch() throws IOException {
        Assert.assertTrue((boolean)this.revocationCache.revoke("context", "item", "value", Duration.ofHours(1L)));
        Assert.assertNull((Object)this.revocationCache.getRevocationRecord("context", "item2"));
        Assert.assertEquals((String)this.revocationCache.getRevocationRecord("context", "item"), (String)"value");
    }

    @Test
    public void testRevokedRecordDelete() throws IOException {
        Assert.assertTrue((boolean)this.revocationCache.revoke("context", "item", "value", Duration.ofHours(1L)));
        Assert.assertEquals((String)this.revocationCache.getRevocationRecord("context", "item"), (String)"value");
        Assert.assertTrue((boolean)this.revocationCache.unrevoke("context", "item"));
        Assert.assertNull((Object)this.revocationCache.getRevocationRecord("context", "item"));
    }
}

