/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.storage.impl.memcached;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import net.shibboleth.utilities.java.support.collection.Pair;
import net.spy.memcached.BinaryConnectionFactory;
import net.spy.memcached.ConnectionFactory;
import net.spy.memcached.MemcachedClient;
import org.cryptacular.generator.IdGenerator;
import org.cryptacular.generator.RandomIdGenerator;
import org.opensaml.storage.StorageRecord;
import org.opensaml.storage.VersionMismatchException;
import org.opensaml.storage.impl.memcached.MemcachedStorageService;
import org.testng.Assert;
import org.testng.annotations.AfterClass;
import org.testng.annotations.BeforeClass;
import org.testng.annotations.DataProvider;
import org.testng.annotations.Test;

@Test(groups={"needs-external-fixture"}, enabled=false)
public class MemcachedStorageServiceTest {
    private MemcachedStorageService service;
    private MemcachedStorageService keyTrackingService;

    @BeforeClass
    public void setUp() throws IOException {
        MemcachedClient client = new MemcachedClient((ConnectionFactory)new BinaryConnectionFactory(), Collections.singletonList(new InetSocketAddress("localhost", 11211)));
        try {
            client.asyncGet("does_not_exist").get(500L, TimeUnit.MILLISECONDS);
        }
        catch (Exception e) {
            Assert.fail((String)"Memcached operation failure. Is memcached running on localhost:11211?", (Throwable)e);
        }
        this.service = new MemcachedStorageService(client, 1);
        this.keyTrackingService = new MemcachedStorageService(client, 1, true);
    }

    @DataProvider
    public Object[][] testValues() {
        return new Object[][]{{"28f1b4f4de961204499bf1d378b9b8ec4f50d46a0ecde454f147f5bb053ca908", "idp_session_key", "qSMyPJN2KCT1z5ZoRCn5xqbkoNH18QgjLQVp68MNocurIaaBiaczZYoMO8WYBwdlrADrAJ0j6cyOwbEIjCtMcA==", "ZufpQlaM2gMDKbzVx7qCWDu+/ke5A5d0TPuMF2lamj5Hd+w3uEGoxkidyxgekzT9Q8hAthyla3p1egoRPpCBqA=="}, {"2769c3850b1e8c7980cba7980cc48f045cfd31efa5e658723f441ac87a4fbac82ed4eee663752bb6f53d774b4fb944c28fe2f6e8d3930a1a72e714cc040d1f35d3c250d48308685fd2681c69fa356b9b45e26274b58f789456f07af316218e344310fc5df3bdd6e9f8c89c780146f32cf7dd53ea1d3ccf6bcbe758e88037917f", "70a0ef338d024c17dec31b8c728547b758430d38d6a594202a5956693cbf1f3708ff07dd02be4032596e6a597a60e3ca4312c874a7c99d84dc74fec64f90221a838b1004ade64c300dbf5aae387c7a1df2e37b1250a3de10bf4a64fefe466fd5f9bffe00a166e976341b27314a4abea12266911943d1fba6564560d4a6eea543", "8XLjjzODxU2Ub4uCKUYZSBoJpgqniyNrHdkYCBo2KTdgc7lZlc8vaTfASSk9P0JZK7SX6LduqykBIiEmzdEzNMU/N16rJJfNweH55L1MLCiEX7bbTiGIiP/lcbqr6k6QX7ZTdsI1R/RTrYENPwlwyfY8hoEEPUcluyf12T1o9heaRcK0ysDlnanSyVQARAWZTq76K3xTr1Ka9DEclT65tsofiFhLUehtbjUbfbLZ7ZXsjmz+ytKJXCtjSWrwO4gzqJ7HrGO7KqVu0ZiaRyJo0HgbzCLRmdfkzw+3bd5cxdjMxkeAuJ3vUH23DL8HcA+kKyJH1GOWXJK8gxRO6V9GEADv", "vFDDoBw7+8SLueXQGHTA1f5DCzQKfGASCAWlX1SQLkNmz4rZ1C6mYiYs69xopBerCc8J2gX5uk+u97f8J2BovRWQ2H10oJtySVbCHiexzxO1jhS2jq1GlFzPJEBqWsLyp4W7so0JKTeNVtBQPM/v/K3lNGeDQBPXYQO+H6QxBwDr9pOx3UZ3sBeYtLo6FVZU+kdzG+4k2B5Sg4F10ocxTpxreFU3yjrhRXWd/uMViOS0Z4sr89LU/YQJFglmys3H18bopaTaatvY76ZCF9ArlSWsnbQiw148Q9x12pz0hc2u1PXeAZKPxJp4Ne0aKAly9NtyQ3eGo0Snmfzy+S1Z4wfp"}};
    }

    @Test(dataProvider="testValues")
    public void testCreateReadUpdateDelete(String context, String key, String value, String updatedValue) throws IOException {
        Assert.assertNull((Object)this.service.read(context, key));
        Assert.assertTrue((boolean)this.service.create(context, key, value, Long.valueOf(5000L)));
        StorageRecord r1 = this.service.read(context, key);
        Assert.assertNotNull((Object)r1);
        Assert.assertEquals((String)r1.getValue(), (String)value);
        Assert.assertTrue((boolean)this.service.update(context, key, updatedValue, Long.valueOf(5000L)));
        StorageRecord r2 = this.service.read(context, key);
        Assert.assertNotNull((Object)r2);
        Assert.assertEquals((String)r2.getValue(), (String)updatedValue);
        Assert.assertTrue((boolean)this.service.delete(context, key));
        Assert.assertNull((Object)this.service.read(context, key));
    }

    @Test(dataProvider="testValues")
    public void testCreateReadUpdateDeleteVersion(String context, String key, String value, String updatedValue) throws IOException, VersionMismatchException {
        Assert.assertNull((Object)this.service.read(context, key));
        Assert.assertTrue((boolean)this.service.create(context, key, value, Long.valueOf(5000L)));
        StorageRecord r1 = this.service.read(context, key);
        Assert.assertNotNull((Object)r1);
        Assert.assertEquals((String)r1.getValue(), (String)value);
        Long updatedVersion = this.service.updateWithVersion(r1.getVersion(), context, key, updatedValue, Long.valueOf(5000L));
        Assert.assertTrue((updatedVersion > r1.getVersion() ? 1 : 0) != 0);
        Pair pair1 = this.service.read(context, key, r1.getVersion());
        Assert.assertEquals((Object)pair1.getFirst(), (Object)updatedVersion);
        Assert.assertEquals((String)((StorageRecord)pair1.getSecond()).getValue(), (String)updatedValue);
        Pair pair2 = this.service.read(context, key, updatedVersion.longValue());
        Assert.assertEquals((Object)pair2.getFirst(), (Object)updatedVersion);
        Assert.assertNull((Object)pair2.getSecond());
        Assert.assertFalse((boolean)this.service.deleteWithVersion(r1.getVersion(), context, key));
        Pair pair3 = this.service.read(context, key, updatedVersion.longValue());
        Assert.assertEquals((Object)pair3.getFirst(), (Object)updatedVersion);
        Assert.assertNull((Object)pair3.getSecond());
        Assert.assertTrue((boolean)this.service.deleteWithVersion(updatedVersion.longValue(), context, key));
        Assert.assertNull((Object)this.service.read(context, key));
    }

    @Test
    public void testDeleteContextDeletesEntries() throws IOException {
        RandomIdGenerator generator = new RandomIdGenerator(50);
        String context = generator.generate();
        String key1 = generator.generate();
        String val1 = generator.generate();
        String key2 = generator.generate();
        String val2 = generator.generate();
        String key3 = generator.generate();
        String val3 = generator.generate();
        Assert.assertTrue((boolean)this.service.create(context, key1, val1, Long.valueOf(1000L)));
        Assert.assertEquals((String)this.service.read(context, key1).getValue(), (String)val1);
        Assert.assertTrue((boolean)this.service.create(context, key2, val2, Long.valueOf(1000L)));
        Assert.assertEquals((String)this.service.read(context, key2).getValue(), (String)val2);
        Assert.assertTrue((boolean)this.service.create(context, key3, val3, Long.valueOf(1000L)));
        Assert.assertEquals((String)this.service.read(context, key3).getValue(), (String)val3);
        this.service.deleteContext(context);
        Assert.assertNull((Object)this.service.read(context, key1));
        Assert.assertNull((Object)this.service.read(context, key2));
        Assert.assertNull((Object)this.service.read(context, key3));
    }

    @Test
    public void testUpdateExpiration() throws IOException {
        RandomIdGenerator generator = new RandomIdGenerator(20);
        String context = generator.generate();
        String key = "expiration_test_key";
        String value = "Oh well, oh well, oh well, oh well";
        Assert.assertTrue((boolean)this.service.create(context, "expiration_test_key", "Oh well, oh well, oh well, oh well", Long.valueOf(30000L)));
        StorageRecord record = this.service.read(context, "expiration_test_key");
        Assert.assertNotNull((Object)record);
        Assert.assertEquals((String)record.getValue(), (String)"Oh well, oh well, oh well, oh well");
        Assert.assertTrue((boolean)this.service.updateExpiration(context, "expiration_test_key", Long.valueOf(System.currentTimeMillis() - 5000L)));
        Assert.assertNull((Object)this.service.read(context, "expiration_test_key"));
    }

    @Test
    public void testUpdateContextExpiration() throws Exception {
        RandomIdGenerator generator = new RandomIdGenerator(20);
        String context = generator.generate();
        Set<String> keySet = this.createContextKeys(context, (IdGenerator)generator, 20);
        this.keyTrackingService.updateContextExpiration(context, Long.valueOf(System.currentTimeMillis() - 5000L));
        for (String k : keySet) {
            Assert.assertNull((Object)this.keyTrackingService.read(context, k));
        }
    }

    @Test
    public void testUpdateContextExpirationWithBlacklisting() throws Exception {
        RandomIdGenerator generator = new RandomIdGenerator(20);
        String context = generator.generate();
        Set<String> keysTBD = this.createContextKeys(context, (IdGenerator)generator, 20);
        for (String key : keysTBD) {
            Assert.assertTrue((boolean)this.keyTrackingService.delete(context, key));
        }
        Set<String> newKeys = this.createContextKeys(context, (IdGenerator)generator, 20);
        this.keyTrackingService.updateContextExpiration(context, Long.valueOf(System.currentTimeMillis() - 5000L));
        HashSet<String> allKeys = new HashSet<String>(keysTBD);
        allKeys.addAll(newKeys);
        for (String k : allKeys) {
            Assert.assertNull((Object)this.keyTrackingService.read(context, k));
        }
    }

    @AfterClass
    public void tearDown() {
        this.service.destroy();
        this.keyTrackingService.destroy();
    }

    private Set<String> createContextKeys(String context, IdGenerator generator, int count) throws IOException {
        String valueBase = "Context value ";
        HashSet<String> keySet = new HashSet<String>();
        for (int i = 0; i < count; ++i) {
            String key = generator.generate();
            boolean result = this.keyTrackingService.create(context, key, "Context value " + i, Long.valueOf(30000L));
            if (!result) continue;
            keySet.add(key);
        }
        Assert.assertEquals((int)keySet.size(), (int)count);
        for (String k : keySet) {
            Assert.assertNotNull((Object)this.keyTrackingService.read(context, k));
        }
        return keySet;
    }
}

