/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.ctx.ActionType;
import org.opensaml.xacml.ctx.AttributeType;
import org.opensaml.xacml.ctx.impl.ActionTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ActionTest
extends XMLObjectProviderBaseTestCase {
    private int expectedNumAttributes;
    private String expectedAttributeId;
    private String expectedDataType;

    public ActionTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/ctx/impl/Action.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/ctx/impl/ActionChildElements.xml";
        this.expectedNumAttributes = 5;
        this.expectedAttributeId = "https://example.org/Action/Attribute/Attribute/Id";
        this.expectedDataType = "https://example.org/Action/Attribute/Data/Type";
    }

    @Test
    public void testSingleElementUnmarshall() {
        ActionType action = (ActionType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)action.getAttributes().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        ActionType action = new ActionTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)action);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ActionType action = (ActionType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)action.getAttributes().size(), (int)this.expectedNumAttributes);
        for (AttributeType attribute : action.getAttributes()) {
            Assert.assertEquals((String)attribute.getAttributeId(), (String)this.expectedAttributeId);
            Assert.assertEquals((String)attribute.getDataType(), (String)this.expectedDataType);
        }
    }

    @Test
    public void testChildElementsMarshall() {
        ActionType action = new ActionTypeImplBuilder().buildObject();
        for (int i = 0; i < this.expectedNumAttributes; ++i) {
            AttributeType attribute = (AttributeType)this.buildXMLObject(AttributeType.DEFAULT_ELEMENT_NAME);
            attribute.setAttributeID(this.expectedAttributeId);
            attribute.setDataType(this.expectedDataType);
            action.getAttributes().add(attribute);
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)action);
    }
}

