/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.ctx.ResponseType;
import org.opensaml.xacml.ctx.ResultType;
import org.opensaml.xacml.ctx.impl.ResponseTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ResponseTest
extends XMLObjectProviderBaseTestCase {
    private int expectedNumResults;

    public ResponseTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/ctx/impl/Response.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/ctx/impl/ResponseChildElements.xml";
        this.expectedNumResults = 6;
    }

    @Test
    public void testSingleElementUnmarshall() {
        ResponseType response = (ResponseType)this.unmarshallElement(this.singleElementFile);
        Assert.assertTrue((boolean)response.getResults().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        ResponseType response = new ResponseTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)response);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ResponseType response = (ResponseType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((int)response.getResults().size(), (int)this.expectedNumResults);
    }

    @Test
    public void testChildElementsMarshall() {
        ResponseType response = new ResponseTypeImplBuilder().buildObject();
        for (int i = 0; i < this.expectedNumResults; ++i) {
            response.getResults().add((ResultType)this.buildXMLObject(ResultType.DEFAULT_ELEMENT_NAME));
        }
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)response);
    }
}

