/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.ctx.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.ctx.StatusCodeType;
import org.opensaml.xacml.ctx.StatusDetailType;
import org.opensaml.xacml.ctx.StatusMessageType;
import org.opensaml.xacml.ctx.StatusType;
import org.opensaml.xacml.ctx.impl.StatusTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class StatusTest
extends XMLObjectProviderBaseTestCase {
    private String expectedValue;
    private String expectedMessage;

    public StatusTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/ctx/impl/Status.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/ctx/impl/StatusChildElements.xml";
        this.expectedValue = "https://example.org/Status/Status/Code";
        this.expectedMessage = "StatusStatusMessageTextstatusCode";
    }

    @Test
    public void testSingleElementUnmarshall() {
        StatusType status = (StatusType)this.unmarshallElement(this.singleElementFile);
        Assert.assertNull((Object)status.getStatusCode());
        Assert.assertNull((Object)status.getStatusMessage());
        Assert.assertNull((Object)status.getStatusDetail());
    }

    @Test
    public void testSingleElementMarshall() {
        StatusType status = new StatusTypeImplBuilder().buildObject();
        this.assertXMLEquals(this.expectedDOM, (XMLObject)status);
    }

    @Test
    public void testChildElementsUnmarshall() {
        StatusType status = (StatusType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)status.getStatusCode().getValue(), (String)this.expectedValue);
        Assert.assertEquals((String)status.getStatusMessage().getValue(), (String)this.expectedMessage);
        Assert.assertNotNull((Object)status.getStatusDetail());
    }

    @Test
    public void testChildElementsMarshall() {
        StatusType status = new StatusTypeImplBuilder().buildObject();
        status.setStatusCode((StatusCodeType)this.buildXMLObject(StatusCodeType.DEFAULT_ELEMENT_NAME));
        status.getStatusCode().setValue(this.expectedValue);
        status.setStatusMessage((StatusMessageType)this.buildXMLObject(StatusMessageType.DEFAULT_ELEMENT_NAME));
        status.getStatusMessage().setValue(this.expectedMessage);
        status.setStatusDetail((StatusDetailType)this.buildXMLObject(StatusDetailType.DEFAULT_ELEMENT_NAME));
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)status);
    }
}

