/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.ApplyType;
import org.opensaml.xacml.policy.AttributeDesignatorType;
import org.opensaml.xacml.policy.AttributeSelectorType;
import org.opensaml.xacml.policy.AttributeValueType;
import org.opensaml.xacml.policy.ConditionType;
import org.opensaml.xacml.policy.ExpressionType;
import org.opensaml.xacml.policy.FunctionType;
import org.opensaml.xacml.policy.VariableReferenceType;
import org.opensaml.xacml.policy.impl.ApplyTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class ApplyTest
extends XMLObjectProviderBaseTestCase {
    private String expectedFunctionId;

    public ApplyTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/policy/impl/Apply.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/policy/impl/ApplyChildElements.xml";
        this.expectedFunctionId = "http://example.org";
    }

    @Test
    public void testSingleElementUnmarshall() {
        ApplyType apply = (ApplyType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)apply.getFunctionId(), (String)this.expectedFunctionId, (String)("MatchId URI has a value of " + apply.getFunctionId() + ", expected a value of " + this.expectedFunctionId));
        Assert.assertTrue((boolean)apply.getExpressions().isEmpty());
    }

    @Test
    public void testSingleElementMarshall() {
        ApplyType apply = new ApplyTypeImplBuilder().buildObject();
        apply.setFunctionId(this.expectedFunctionId);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)apply);
    }

    @Test
    public void testChildElementsUnmarshall() {
        ApplyType apply = (ApplyType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)apply.getFunctionId(), (String)this.expectedFunctionId, (String)("FunctionId URI has a value of " + apply.getFunctionId() + ", expected a value of " + this.expectedFunctionId));
        Assert.assertEquals((int)apply.getExpressions().size(), (int)9);
    }

    @Test
    public void testChildElementsMarshall() {
        ApplyType apply = new ApplyTypeImplBuilder().buildObject();
        apply.setFunctionId(this.expectedFunctionId);
        apply.getExpressions().add((ExpressionType)this.buildXMLObject(FunctionType.DEFAULT_ELEMENT_NAME));
        apply.getExpressions().add((ExpressionType)this.buildXMLObject(AttributeValueType.DEFAULT_ELEMENT_NAME));
        apply.getExpressions().add((ExpressionType)this.buildXMLObject(ConditionType.DEFAULT_ELEMENT_NAME));
        apply.getExpressions().add((ExpressionType)this.buildXMLObject(AttributeValueType.DEFAULT_ELEMENT_NAME));
        apply.getExpressions().add((ExpressionType)this.buildXMLObject(VariableReferenceType.DEFAULT_ELEMENT_NAME_XACML20));
        apply.getExpressions().add((ExpressionType)this.buildXMLObject(AttributeDesignatorType.ACTION_ATTRIBUTE_DESIGNATOR_ELEMENT_NAME));
        apply.getExpressions().add((ExpressionType)this.buildXMLObject(AttributeSelectorType.DEFAULT_ELEMENT_NAME));
        apply.getExpressions().add((ExpressionType)this.buildXMLObject(FunctionType.DEFAULT_ELEMENT_NAME));
        ApplyType other = (ApplyType)this.buildXMLObject(ApplyType.DEFAULT_ELEMENT_NAME);
        other.setFunctionId(this.expectedFunctionId);
        apply.getExpressions().add(other);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)apply);
    }
}

