/*
 * Decompiled with CFR 0.152.
 */
package org.opensaml.xacml.policy.impl;

import org.opensaml.core.xml.XMLObject;
import org.opensaml.core.xml.XMLObjectProviderBaseTestCase;
import org.opensaml.xacml.policy.AttributeValueType;
import org.opensaml.xacml.policy.CombinerParameterType;
import org.opensaml.xacml.policy.impl.AttributeValueTypeImplBuilder;
import org.opensaml.xacml.policy.impl.CombinerParameterTypeImplBuilder;
import org.testng.Assert;
import org.testng.annotations.Test;

public class CombinerParameterTest
extends XMLObjectProviderBaseTestCase {
    private String expectedDataType;
    private String expectedParameterName;

    public CombinerParameterTest() {
        this.singleElementFile = "/data/org/opensaml/xacml/policy/impl/CombinerParameter.xml";
        this.childElementsFile = "/data/org/opensaml/xacml/policy/impl/CombinerParameterChildElements.xml";
        this.expectedDataType = "https://example.org/Combiner/Parameter/Type";
        this.expectedParameterName = "nameParameter";
    }

    @Test
    public void testSingleElementUnmarshall() {
        CombinerParameterType combiner = (CombinerParameterType)this.unmarshallElement(this.singleElementFile);
        Assert.assertEquals((String)combiner.getParameterName(), (String)this.expectedParameterName);
        Assert.assertNull((Object)combiner.getAttributeValue());
    }

    @Test
    public void testSingleElementMarshall() {
        CombinerParameterType combiner = new CombinerParameterTypeImplBuilder().buildObject();
        combiner.setParameterName(this.expectedParameterName);
        this.assertXMLEquals(this.expectedDOM, (XMLObject)combiner);
    }

    @Test
    public void testChildElementsMarshall() {
        CombinerParameterType combiner = new CombinerParameterTypeImplBuilder().buildObject();
        combiner.setParameterName(this.expectedParameterName);
        AttributeValueType attributeValue = new AttributeValueTypeImplBuilder().buildObject();
        attributeValue.setDataType(this.expectedDataType);
        combiner.setAttributeValue(attributeValue);
        this.assertXMLEquals(this.expectedChildElementsDOM, (XMLObject)combiner);
    }

    @Test
    public void testChildElementsUnmarshall() {
        CombinerParameterType combiner = (CombinerParameterType)this.unmarshallElement(this.childElementsFile);
        Assert.assertEquals((String)combiner.getParameterName(), (String)this.expectedParameterName);
        Assert.assertEquals((String)combiner.getAttributeValue().getDataType(), (String)this.expectedDataType);
    }
}

